(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/143#fx-width ##fixnum-width)
  (define std/srfi/143#fx-greatest ##max-fixnum)
  (define std/srfi/143#fx-least ##min-fixnum)
  (define std/srfi/143#fxneg (lambda (_x495_) (fx- _x495_)))
  (define std/srfi/143#fxsqrt
    (lambda (_x493_) (let () (declare (not safe)) (##integer-sqrt _x493_))))
  (define std/srfi/143#fxcopy-bit
    (lambda (_index489_ _to490_ _bool491_)
      (if _bool491_
          (fxior _to490_ (fxarithmetic-shift-left '1 _index489_))
          (fxand _to490_ (fxnot (fxarithmetic-shift-left '1 _index489_))))))
  (define std/srfi/143#fxfirst-set-bit
    (lambda (_i487_) (fx- (fxbit-count (fxxor _i487_ (fx- _i487_ '1))) '1)))
  (define std/srfi/143#mask
    (lambda (_start484_ _end485_)
      (fxnot (fxarithmetic-shift-left '-1 (fx- _end485_ _start484_)))))
  (define std/srfi/143#fxbit-field
    (lambda (_n480_ _start481_ _end482_)
      (fxand (std/srfi/143#mask _start481_ _end482_)
             (fxarithmetic-shift _n480_ (fx- _start481_)))))
  (define std/srfi/143#fxbit-field-rotate
    (lambda (_n469_ _count470_ _start471_ _end472_)
      (letrec* ((_width474_ (fx- _end472_ _start471_)))
        (set! _count470_ (fxmodulo _count470_ _width474_))
        (let ((_mask476_ (fxnot (fxarithmetic-shift '-1 _width474_))))
          (letrec* ((_zn478_ (fxand _mask476_
                                    (fxarithmetic-shift
                                     _n469_
                                     (fx- _start471_)))))
            (fxior (fxarithmetic-shift
                    (fxior (fxand _mask476_
                                  (fxarithmetic-shift _zn478_ _count470_))
                           (fxarithmetic-shift
                            _zn478_
                            (fx- _count470_ _width474_)))
                    _start471_)
                   (fxand (fxnot (fxarithmetic-shift _mask476_ _start471_))
                          _n469_)))))))
  (define std/srfi/143#fxreverse
    (lambda (_k459_ _n460_)
      (let _$loop462_ ((_m465_ (if (fxnegative? _n460_) (fxnot _n460_) _n460_))
                       (_k466_ (fx+ '-1 _k459_))
                       (_rvs467_ '0))
        (if (fxnegative? _k466_)
            (if (fxnegative? _n460_) (fxnot _rvs467_) _rvs467_)
            (_$loop462_
             (fxarithmetic-shift-right _m465_ '1)
             (fx+ '-1 _k466_)
             (fxior (fxarithmetic-shift-left _rvs467_ '1)
                    (fxand '1 _m465_)))))))
  (define std/srfi/143#fxbit-field-reverse
    (lambda (_n449_ _start450_ _end451_)
      (letrec* ((_width453_ (fx- _end451_ _start450_)))
        (let ((_mask455_ (fxnot (fxarithmetic-shift-left '-1 _width453_))))
          (letrec* ((_zn457_ (fxand _mask455_
                                    (fxarithmetic-shift-right
                                     _n449_
                                     _start450_))))
            (fxior (fxarithmetic-shift-left
                    (std/srfi/143#fxreverse _width453_ _zn457_)
                    _start450_)
                   (fxand (fxnot (fxarithmetic-shift-left
                                  _mask455_
                                  _start450_))
                          _n449_)))))))
  (define std/srfi/143#exp-width (expt '2 std/srfi/143#fx-width))
  (define std/srfi/143#fx+/carry
    (lambda (_i439_ _j440_ _k441_)
      (let* ((_s443_ (+ _i439_ _j440_ _k441_))
             (_g4095_ (std/srfi/143#balanced/ _s443_ std/srfi/143#exp-width)))
        (begin
          (let ((_g4096_ (let ()
                           (declare (not safe))
                           (if (##values? _g4095_)
                               (##vector-length _g4095_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4096_ 2)))
                (error "Context expects 2 values" _g4096_)))
          (let ((_q445_ (let () (declare (not safe)) (##vector-ref _g4095_ 0)))
                (_r446_ (let ()
                          (declare (not safe))
                          (##vector-ref _g4095_ 1))))
            (let () (values _r446_ _q445_)))))))
  (define std/srfi/143#fx-/carry
    (lambda (_i429_ _j430_ _k431_)
      (let* ((_d433_ (- _i429_ _j430_ _k431_))
             (_g4097_ (std/srfi/143#balanced/ _d433_ std/srfi/143#exp-width)))
        (begin
          (let ((_g4098_ (let ()
                           (declare (not safe))
                           (if (##values? _g4097_)
                               (##vector-length _g4097_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4098_ 2)))
                (error "Context expects 2 values" _g4098_)))
          (let ((_q435_ (let () (declare (not safe)) (##vector-ref _g4097_ 0)))
                (_r436_ (let ()
                          (declare (not safe))
                          (##vector-ref _g4097_ 1))))
            (let () (values _r436_ _q435_)))))))
  (define std/srfi/143#fx*/carry
    (lambda (_i419_ _j420_ _k421_)
      (let* ((_s423_ (+ (* _i419_ _j420_) _k421_))
             (_g4099_ (std/srfi/143#balanced/ _s423_ std/srfi/143#exp-width)))
        (begin
          (let ((_g4100_ (let ()
                           (declare (not safe))
                           (if (##values? _g4099_)
                               (##vector-length _g4099_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4100_ 2)))
                (error "Context expects 2 values" _g4100_)))
          (let ((_q425_ (let () (declare (not safe)) (##vector-ref _g4099_ 0)))
                (_r426_ (let ()
                          (declare (not safe))
                          (##vector-ref _g4099_ 1))))
            (let () (values _r426_ _q425_)))))))
  (define std/srfi/143#floor-/+
    (lambda (_n411_ _d412_)
      (let ((_n414_ (- '0 _n411_)))
        (let ((_q416_ (quotient _n414_ _d412_))
              (_r417_ (remainder _n414_ _d412_)))
          (if (zero? _r417_)
              (values (- '0 _q416_) _r417_)
              (values (- (- '0 _q416_) '1) (- _d412_ _r417_)))))))
  (define std/srfi/143#ceiling-/-
    (lambda (_n402_ _d403_)
      (let ((_n405_ (- '0 _n402_)) (_d406_ (- '0 _d403_)))
        (let ((_q408_ (quotient _n405_ _d406_))
              (_r409_ (remainder _n405_ _d406_)))
          (if (zero? _r409_)
              (values _q408_ _r409_)
              (values (+ _q408_ '1) (- _d406_ _r409_)))))))
  (define std/srfi/143#euclidean/
    (lambda (_n395_ _d396_)
      (if (and (exact-integer? _n395_) (exact-integer? _d396_))
          (if (and (negative? _n395_) (negative? _d396_))
              (std/srfi/143#ceiling-/- _n395_ _d396_)
              (if (negative? _n395_)
                  (std/srfi/143#floor-/+ _n395_ _d396_)
                  (if (negative? _d396_)
                      (let ((_d398_ (- '0 _d396_)))
                        (values (- '0 (quotient _n395_ _d398_))
                                (remainder _n395_ _d398_)))
                      (values (quotient _n395_ _d396_)
                              (remainder _n395_ _d396_)))))
          (let ((_q400_ (if (negative? _d396_)
                            (ceiling (/ _n395_ _d396_))
                            (floor (/ _n395_ _d396_)))))
            (values _q400_ (- _n395_ (* _d396_ _q400_)))))))
  (define std/srfi/143#balanced/
    (lambda (_x388_ _y389_)
      (call-with-values
       (lambda () (std/srfi/143#euclidean/ _x388_ _y389_))
       (lambda (_q392_ _r393_)
         (if (< _r393_ (abs (/ _y389_ '2)))
             (values _q392_ _r393_)
             (if (> _y389_ '0)
                 (values (+ _q392_ '1) (- _x388_ (* (+ _q392_ '1) _y389_)))
                 (values (- _q392_ '1)
                         (- _x388_ (* (- _q392_ '1) _y389_))))))))))
