/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.actions;

import com.almworks.tracker.eapi.alpha.ConnectionState;
import com.almworks.tracker.eapi.alpha.TrackerConnectionStatus;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.IssueLink;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.dialogs.StartDeskzillaConfirmationDialog;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.ArrayList;

public class OpenArtifactsAction
extends AnAction {
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        String anObject = e.getPlace();
        IssueLink links = Utils.getIssueLinks(dataContext);
        TrackerConnector connector = Utils.getConnector(dataContext);
        TrackLinkPlugin plugin = Utils.getTrackLinkPlugin(dataContext);
        boolean enabled = false;
        String text = null;
        if (links != null && connector != null && plugin != null) {
            TrackerConnectionStatus status = (TrackerConnectionStatus)connector.getTrackerStarter().getConnectionStatus().getValue();
            if (status != null && status.getConnectionState() == ConnectionState.CONNECTED) {
                text = status.getTrackerName();
                enabled = true;
            } else {
                text = plugin.getIssueModel().getApplicationDisplayName();
                enabled = text != null;
            }
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
        if (text != null) {
            text = StringBundle.get("action.openIssues.inTracker", text);
            e.getPresentation().setText(text);
        }
        Utils.checkVisibility(e);
    }

    private boolean isInEditor(DataContext context) {
        return DataKeys.EDITOR.getData(context) != null;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        TrackerConnector connector = Utils.getConnector(dataContext);
        if (connector == null) {
            return;
        }
        TrackLinkPlugin plugin = Utils.getTrackLinkPlugin(dataContext);
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        Component component = (Component)DataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (plugin == null || project == null || component == null) {
            return;
        }
        IssueLink links = Utils.getIssueLinks(dataContext);
        if (links != null) {
            if (!((TrackerConnectionStatus)connector.getTrackerStarter().getConnectionStatus().getValue()).isConnected()) {
                this.maybeStartTracker(plugin, project, e);
            }
            ArrayList<String> coll = new ArrayList<String>(1);
            coll.add(links.getURL());
            connector.getArtifactOpener().openArtifacts(coll);
        }
    }

    private boolean maybeStartTracker(TrackLinkPlugin plugin, Project project, AnActionEvent e) {
        IssueLinkModel model = plugin.getIssueModel();
        if (!model.isAutoStartingAllowed()) {
            StartDeskzillaConfirmationDialog confirmationDialog = new StartDeskzillaConfirmationDialog(model, project);
            confirmationDialog.show();
            if (0 != confirmationDialog.getExitCode()) {
                return false;
            }
        }
        return Utils.startDeskzilla(e);
    }
}

