'\"
'\" Generated from file 'pdf4tcl\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007-2016 Peter Spjuth
'\" Copyright (c) 2009 Yaroslav Schekin
'\"
.TH "pdf4tcl" n 0\&.9\&.1 pdf4tcl "Pdf document generation"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pdf4tcl \- Pdf document generation
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBpdf4tcl  ?0\&.9\&.1?\fR
.sp
\fB::pdf4tcl::new\fR \fIobjectName\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fB::pdf4tcl::getPaperSize\fR \fIpaper\fR
.sp
\fB::pdf4tcl::getPaperSizeList\fR
.sp
\fB::pdf4tcl::getPoints\fR \fIval\fR
.sp
\fB::pdf4tcl::loadBaseTrueTypeFont\fR \fIbasefontname\fR \fIttf_file_name\fR
.sp
\fB::pdf4tcl::createBaseTrueTypeFont\fR \fIbasefontname\fR \fIttf_data\fR
.sp
\fB::pdf4tcl::loadBaseType1Font\fR \fIbasefontname\fR \fIAFM_file_name\fR \fIPFB_file_name\fR
.sp
\fB::pdf4tcl::createBaseType1Font\fR \fIbasefontname\fR \fIAFM_data\fR \fIPFB_data\fR
.sp
\fB::pdf4tcl::createFont\fR \fIbasefontname\fR \fIfontname\fR \fIencoding_name\fR
.sp
\fB::pdf4tcl::createFontSpecEnc\fR \fIbasefontname\fR \fIfontname\fR \fIsubset\fR
.sp
\fB::pdf4tcl::getFonts\fR
.sp
\fB::pdf4tcl::rgb2Cmyk\fR \fIrgb\fR
.sp
\fB::pdf4tcl::cmyk2Rgb\fR \fIcmyk\fR
.sp
\fB::pdf4tcl::catPdf\fR \fIinfile\fR ?\fIinfile \&.\&.\&.\fR? \fIoutfile\fR
.sp
\fBobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fIobjectName\fR \fBconfigure\fR
.sp
\fIobjectName\fR \fBconfigure\fR \fIoption\fR
.sp
\fIobjectName\fR \fBconfigure\fR \fB-option\fR \fIvalue\fR\&.\&.\&.
.sp
\fIobjectName\fR \fBcget\fR \fB-option\fR
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBstartPage\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBendPage\fR
.sp
\fIobjectName\fR \fBstartXObject\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBendXObject\fR
.sp
\fIobjectName\fR \fBfinish\fR
.sp
\fIobjectName\fR \fBget\fR
.sp
\fIobjectName\fR \fBwrite\fR ?\fI-file filename\fR?
.sp
\fIobjectName\fR \fBaddForm\fR \fItype\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBgetDrawableArea\fR
.sp
\fIobjectName\fR \fBcanvas\fR \fIpath\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBmetadata\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBbookmarkAdd\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBembedFile\fR \fIfilename\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBattachFile\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR \fIfid\fR \fIdescription\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBsetFont\fR \fIsize\fR ?\fIfontname\fR?
.sp
\fIobjectName\fR \fBgetStringWidth\fR \fIstr\fR
.sp
\fIobjectName\fR \fBgetCharWidth\fR \fIchar\fR
.sp
\fIobjectName\fR \fBsetTextPosition\fR \fIx\fR \fIy\fR
.sp
\fIobjectName\fR \fBmoveTextPosition\fR \fIdx\fR \fIdy\fR
.sp
\fIobjectName\fR \fBgetTextPosition\fR
.sp
\fIobjectName\fR \fBnewLine\fR ?\fIspacing\fR?
.sp
\fIobjectName\fR \fBsetLineSpacing\fR \fIspacing\fR
.sp
\fIobjectName\fR \fBgetLineSpacing\fR
.sp
\fIobjectName\fR \fBtext\fR \fIstr\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBdrawTextBox\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR \fIstr\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBgetFontMetric\fR \fImetric\fR
.sp
\fIobjectName\fR \fBputImage\fR \fIid\fR \fIx\fR \fIy\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBputRawImage\fR \fIdata\fR \fIx\fR \fIy\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBaddImage\fR \fIfilename\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBaddRawImage\fR \fIdata\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBgetImageHeight\fR \fIid\fR
.sp
\fIobjectName\fR \fBgetImageSize\fR \fIid\fR
.sp
\fIobjectName\fR \fBgetImageWidth\fR \fIid\fR
.sp
\fIobjectName\fR \fBsetBgColor\fR \fIred\fR \fIgreen\fR \fIblue\fR
.sp
\fIobjectName\fR \fBsetBgColor\fR \fIc\fR \fIm\fR \fIy\fR \fIk\fR
.sp
\fIobjectName\fR \fBsetFillColor\fR \fIred\fR \fIgreen\fR \fIblue\fR
.sp
\fIobjectName\fR \fBsetFillColor\fR \fIc\fR \fIm\fR \fIy\fR \fIk\fR
.sp
\fIobjectName\fR \fBsetStrokeColor\fR \fIred\fR \fIgreen\fR \fIblue\fR
.sp
\fIobjectName\fR \fBsetStrokeColor\fR \fIc\fR \fIm\fR \fIy\fR \fIk\fR
.sp
\fIobjectName\fR \fBsetLineWidth\fR \fIwidth\fR
.sp
\fIobjectName\fR \fBsetLineDash\fR ?\fIon off\fR\&.\&.\&.? ?\fIoffset\fR?
.sp
\fIobjectName\fR \fBsetLineStyle\fR \fIwidth\fR \fIargs\fR
.sp
\fIobjectName\fR \fBline\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
.sp
\fIobjectName\fR \fBcurve\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIx3\fR \fIy3\fR ?\fIx4 y4\fR?
.sp
\fIobjectName\fR \fBpolygon\fR ?\fIx y\fR\&.\&.\&.? ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBcircle\fR \fIx\fR \fIy\fR \fIradius\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBoval\fR \fIx\fR \fIy\fR \fIradiusx\fR \fIradiusy\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBarc\fR \fIx\fR \fIy\fR \fIradiusx\fR \fIradiusy\fR \fIphi\fR \fIextend\fR ?\fIoption value\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBarrow\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIsize\fR ?\fIangle\fR?
.sp
\fIobjectName\fR \fBrectangle\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR ?\fIoption value\fR\&.\&.\&.?
.sp
.BE
.SH DESCRIPTION
This package provides a container class for generating \fIpdf\fR documents\&.
.SH COORDINATES
All coordinates and distances can be expressed with or without a unit\&. See
\fBUNITS\fR for valid units\&.
When the page is configured with \fB-orient\fR set to false, origin is in
the bottom left corner\&. With \fB-orient\fR true (the default), origin is in the top left
corner\&.
Origin is displaced to account for margins, i\&.e\&. if margins are 100,
the user coordinate (0,0) corresponds to (100,100) on the paper\&.
Page option \fB-orient\fR can also affect the anchor point for things like
images\&.
.SH UNITS
Any coordinates and distances can be expressed with or without an explicit
unit\&.  If no unit is given, the default unit for the document is used\&.
A unit may be one of
\fBmm\fR (millimeter),
\fBm\fR (millimeter),
\fBcm\fR (centimeter),
\fBc\fR (centimeter),
\fBp\fR (points) or
\fBi\fR (inches)\&.
Commands returning coordinates or distances always return a double value
in the document's default unit\&.
.SH "PUBLIC API"
.SS "PACKAGE COMMANDS"
.TP
\fB::pdf4tcl::new\fR \fIobjectName\fR ?\fIoption value\fR\&.\&.\&.?
This command creates a new pdf4tcl object with an associated Tcl
command whose name is \fIobjectName\fR\&. This \fIobject\fR command is
explained in full detail in the sections \fBOBJECT COMMAND\fR
and \fBOBJECT METHODS\fR\&. The object command will be created
under the current namespace if the \fIobjectName\fR is not fully
qualified, and in the specified namespace otherwise\&.
If \fIobjectName\fR is %AUTO% a name will generated\&.
The return value is the newly created object's name\&.
.sp
The options and their values coming after the name of the object are
used to set the initial configuration of the object\&.
See \fBOBJECT CONFIGURATION\fR\&.
.TP
\fB::pdf4tcl::getPaperSize\fR \fIpaper\fR
This call returns the size of a named paper type, e\&.g\&. "a4"\&.
Paper names are case insensitive\&.
The argument \fIpaper\fR may also be a two element list
with values as accepted by \fB::pdf4tcl::getPoints\fR\&.
The return value is a list with width and height in points\&.
.TP
\fB::pdf4tcl::getPaperSizeList\fR
This call returns the list of known paper types\&.
.TP
\fB::pdf4tcl::getPoints\fR \fIval\fR
This call translates a measurement to points (1/72 inch)\&.
The format of \fIval\fR is '\fInum\fR ?\fIunit\fR?' where
\fInum\fR is a valid integer or double\&. See \fBUNITS\fR for valid
\fIunit\fRs\&.  If no \fIunit\fR is given, the value is interpreted
as points\&.
.TP
\fB::pdf4tcl::loadBaseTrueTypeFont\fR \fIbasefontname\fR \fIttf_file_name\fR
This call loads a TTF font from file to be used by any pdf4tcl objects\&.
The \fIbasefontname\fR is used to reference this font\&.
To use this base font in documents, a font with some encoding must be
created from it using createFont\&.
Note that the font loading functions require Tcl 8\&.5\&.
.TP
\fB::pdf4tcl::createBaseTrueTypeFont\fR \fIbasefontname\fR \fIttf_data\fR
This call creates a base font from TTF binary data\&.
.TP
\fB::pdf4tcl::loadBaseType1Font\fR \fIbasefontname\fR \fIAFM_file_name\fR \fIPFB_file_name\fR
This call loads a Type1 font from two files (\&.afm and \&.pfb) to be used by
any pdf4tcl objects\&. The \fIbasefontname\fR is used to reference this font\&.
To use this base font in documents, a font with some encoding must be
created from it using createFont\&.
.TP
\fB::pdf4tcl::createBaseType1Font\fR \fIbasefontname\fR \fIAFM_data\fR \fIPFB_data\fR
This call creates a base font from AFM text and PFB binary data\&.
.TP
\fB::pdf4tcl::createFont\fR \fIbasefontname\fR \fIfontname\fR \fIencoding_name\fR
This call creates a font that can be used in documents from a base font\&.
.CS


pdf4tcl::loadBaseTrueTypeFont BaseArial "arial\&.ttf"
pdf4tcl::createFont BaseArial MyArial cp1251
pdf4tcl::loadBaseType1Font BaseType1 "a010013l\&.afm" "a010013l\&.pfb"
pdf4tcl::createFont BaseType1 MyType1 cp1251
pdf4tcl::new mypdf -paper a4 -compress 0
mypdf startPage
mypdf setFont 10 MyArial
set txt "\\u042D\\u0442\\u043E \\u0442\\u0435\\u043A\\u0441\\u0442 \\u043D\\u0430 \\u0440\\u0443\\u0441\\u0441\\u043A\\u043E\\u043C\\
         \\u044F\\u0437\\u044B\\u043A\\u0435\&. This is text in Russian\&."
mypdf text $txt -bg #CACACA -x 50 -y 100
mypdf setFont 10 MyType1
mypdf text $txt -x 50 -y 200
mypdf write -file fonts\&.pdf
mypdf destroy

.CE
.TP
\fB::pdf4tcl::createFontSpecEnc\fR \fIbasefontname\fR \fIfontname\fR \fIsubset\fR
This call creates a font that can be used in documents from a base font\&.
The \fIsubset\fR must be a list of unicode values\&.
.TP
\fB::pdf4tcl::getFonts\fR
This call returns the list of known font names, i\&.e\&. those accepted in a call
to \fBsetFont\fR\&.
This includes the default fonts and fonts created by e\&.g\&.
\fB::pdf4tcl::createFont\fR\&.
.TP
\fB::pdf4tcl::rgb2Cmyk\fR \fIrgb\fR
This call translates an RGB color value to a CMYK color value\&.
It is used internally if \fB-cmyk\fR was set at object creation to
translate colors\&.
You can redefine this procedure to provide your own translation\&.
.TP
\fB::pdf4tcl::cmyk2Rgb\fR \fIcmyk\fR
This call translates a CMYK color value to an RGB color value\&.
It is used internally to translate colors\&.
You can redefine this procedure to provide your own translation\&.
.TP
\fB::pdf4tcl::catPdf\fR \fIinfile\fR ?\fIinfile \&.\&.\&.\fR? \fIoutfile\fR
This call concatenates PDF files into one\&.
Currently the implementation limits the PDFs a lot since not all details
are taken care of yet\&. Straightforward ones like those created with pdf4tcl
or ps2pdf should work mostly ok\&.
.PP
.SS "OBJECT COMMAND"
All commands created by \fB::pdf4tcl::new\fR have the following
general form and may be used to invoke various operations on their
pdf object\&.
.TP
\fBobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the exact
behavior of the command\&. See section \fBOBJECT METHODS\fR for
the detailed specifications\&.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBconfigure\fR
The method returns a list of all known options and their current
values when called without any arguments\&.
.TP
\fIobjectName\fR \fBconfigure\fR \fIoption\fR
The method behaves like the method \fBcget\fR when called with a
single argument and returns the value of the option specified by said
argument\&.
.TP
\fIobjectName\fR \fBconfigure\fR \fB-option\fR \fIvalue\fR\&.\&.\&.
The method reconfigures the specified \fBoption\fRs of the object,
setting them to the associated \fIvalue\fRs, when called with an even
number of arguments, at least two\&.
.sp
The legal options are described in the section
\fBOBJECT CONFIGURATION\fR\&.
.TP
\fIobjectName\fR \fBcget\fR \fB-option\fR
This method expects a legal configuration option as argument and will
return the current value of that option for the object the method was
invoked for\&.
.sp
The legal configuration options are described in section
\fBOBJECT CONFIGURATION\fR\&.
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object it is invoked for\&.
If the \fB-file\fR option was given at object creation,
the output file will be finished and closed\&.
.TP
\fIobjectName\fR \fBstartPage\fR ?\fIoption value\fR\&.\&.\&.?
This method starts a new page in the document\&. The page will have the
default page settings for the document unless overridden by \fIoption\fR\&.
See \fBPAGE CONFIGURATION\fR for page settings\&.
This will end any ongoing page\&.
.TP
\fIobjectName\fR \fBendPage\fR
This method ends a page in the document\&.  It is normally not needed since
it is implied by e\&.g\&. \fBstartPage\fR and \fBfinish\fR\&.  However,
if the document is built page by page in e\&.g\&. an event driven environment
it can be good to call \fBendPage\fR explicitly to have all the page's
work finished before reentering the event loop\&.
.TP
\fIobjectName\fR \fBstartXObject\fR ?\fIoption value\fR\&.\&.\&.?
This method starts a new XObject in the document\&.  An XObject is a reusable
drawing object and behaves just like a page where you can draw any graphics\&.
An XObject must be created between pages and this method will end any ongoing
page\&. The return value is an id that can be used with \fBputImage\fR to draw
it on the current page or with some forms\&.
All page settings (\fBPAGE CONFIGURATION\fR) are
valid when creating an XObject\&. Default options are
\fB-paper\fR = {100p 100p}, \fB-landscape\fR = 0,
\fB-orient\fR = document default, \fB-margin\fR= 0\&.
.RS
.TP
\fB-noimage\fR \fIbool\fR
If this is set the XObject is not added to the image resource set and cannot
be used with putImage, only in forms\&. The XObject also gets access to resources
which is needed to use e\&.g\&. fonts within the XObject\&. This behaviour has shown
to be PDF reader dependent, and it is currently not known if this can be
made to work better\&.
.RE
.TP
\fIobjectName\fR \fBendXObject\fR
This method ends an XObject definition\&. It works just like \fBendPage\fR\&.
.TP
\fIobjectName\fR \fBfinish\fR
This method ends the document\&.
This will do \fBendPage\fR if needed\&.
If the \fB-file\fR option was given at object creation,
the output file will be finished and closed\&.
.TP
\fIobjectName\fR \fBget\fR
This method returns the generated pdf\&.
This will do \fBendPage\fR and \fBfinish\fR if needed\&.
If the \fB-file\fR option was given at object creation, nothing is returned\&.
.TP
\fIobjectName\fR \fBwrite\fR ?\fI-file filename\fR?
This method writes the generated pdf to the given \fIfilename\fR\&.
If no \fIfilename\fR is given, it is written to stdout\&.
This will do \fBendPage\fR and \fBfinish\fR if needed\&.
If the \fB-file\fR option was given at object creation, an empty file
is created\&.
.TP
\fIobjectName\fR \fBaddForm\fR \fItype\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR ?\fIoption value\fR\&.\&.\&.?
Add an interactive form at the given position and size\&. Supported types are \fItext\fR and \fIcheckbutton\fR\&.
Option \fI-init\fR gives an initial value for the form\&.
For a checkbutton, options \fI-on\fR and \fI-off\fR can be given an xobject (created with \fBstartXObject\fR) to control its appearance\&.
.PP
.SS "OBJECT METHODS, PAGE"
.TP
\fIobjectName\fR \fBgetDrawableArea\fR
This method returns the size of the available area on the page,
after removing margins\&.  The return value is a list of width and height,
in the document's default unit\&.
.TP
\fIobjectName\fR \fBcanvas\fR \fIpath\fR ?\fIoption value\fR\&.\&.\&.?
Draws the contents of the canvas widget \fIpath\fR on the current page\&.
Option \fI-bbox\fR gives the area of the canvas to be drawn\&. Default is
the entire contents, i\&.e\&. the result of $path bbox all\&.
Options \fI-x\fR, \fI-y\fR, \fI-width\fR and \fI-height\fR defines
an area on the page where to place the contents\&. Default area starts at origin,
stretching over the drawable area of the page\&.
Option \fI-sticky\fR defines how to place the contents within the area\&.
The area is always filled in one direction, preserving aspect ratio, unless
\fI-sticky\fR defines that the other direction should be filled too\&.  Default
\fI-sticky\fR is \fInw\fR\&.
If option \fI-bg\fR is true, a background is drawn in the canvas' background
color\&.  Otherwise only objects are drawn\&.  Default is false\&.
Option \fI-fontmap\fR gives a dictionary mapping from Tk font names to PDF font names\&.
.sp
Fonts:
.sp
If no font mapping is given, fonts for text items are limited to PDF's
builtins, i\&.e\&. Helvetica, Times and Courier\&. A guess is made to chose which
one to use to get a reasonable display on the page\&.
.sp
An element in a font mapping must exactly match the -font option in the
text item\&. The corresponding mapping value is a PDF font family, e\&.g\&. one
created by \fBpdf4tcl::createFont\fR\&. It is recommended to use named fonts
in Tk to control the font mapping in detail\&.
.sp
Limitations:
.sp
Option -splinesteps for lines/polygons is ignored\&.
.sp
Stipple offset is limited\&. The form x,y should work\&.
.sp
Window items require Img to be present and must be visible on-screen when
the canvas is drawn\&.
.TP
\fIobjectName\fR \fBmetadata\fR ?\fIoption value\fR\&.\&.\&.?
This method sets metadata fields for this document\&.  Supported field options are
\fI-author\fR, \fI-creator\fR, \fI-keywords\fR, \fI-producer\fR, \fI-subject\fR,
\fI-title\fR, \fI-creationdate\fR and \fI-format\fR\&.
.TP
\fIobjectName\fR \fBbookmarkAdd\fR ?\fIoption value\fR\&.\&.\&.?
Add a bookmark on the current page\&.
.RS
.TP
\fB-title\fR \fItext\fR
Set the text of the bookmark\&.
.TP
\fB-level\fR \fIlevel\fR
Set the level of the bookmark\&. Default is 0\&.
.TP
\fB-closed\fR \fIboolean\fR
Select if the bookmark is closed by default\&. Default is false, i\&.e\&. not closed\&.
.RE
.TP
\fIobjectName\fR \fBembedFile\fR \fIfilename\fR ?\fIoption value\fR\&.\&.\&.?
This method embeds a file into the PDF stream\&. File data is considered binary\&. Returns an id that can be used in subsequent calls to \fBattachFile\fR\&.
.RS
.TP
\fB-id\fR \fIid\fR
Explicitly select an id for the file\&. The \fIid\fR must be unique within the document\&.
.TP
\fB-contents\fR \fIdata\fR
Provides the file contents instead of reading the actual file\&.
.RE
.TP
\fIobjectName\fR \fBattachFile\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR \fIfid\fR \fIdescription\fR ?\fIoption value\fR\&.\&.\&.?
This method adds a file annotation to the current page\&. The location of the file annotation is given by the coordinates \fIx\fR, \fIy\fR, \fIwidth\fR, \fIheight\fR\&. The annotation is rendered by default as a paperclip icon, which allows the extraction of the attached file\&. An \fIfid\fR from a previous call to \fBembedFile\fR must be set as well as a \fIdescription\fR, which is shown by the PDF viewer upon activating the annotation\&.
.RS
.TP
\fB-icon\fR \fIicon\fR
Controls the appearance of the attachment\&. Valid values are Paperclip, Tag, Graph, or PushPin\&. Default value is Paperclip\&.
.RE
.CS


set fid [$pdfobject embedFile "data\&.txt" -contents "This should be stored in the file\&."]
$pdfobject attachFile 0 0 100 100 $fid "This is the description"

.CE
.PP
.SS "OBJECT METHODS, TEXT"
.TP
\fIobjectName\fR \fBsetFont\fR \fIsize\fR ?\fIfontname\fR?
This method sets the font used by text drawing routines\&. If \fIfontname\fR
is not provided, the previously set \fIfontname\fR is kept\&.
.TP
\fIobjectName\fR \fBgetStringWidth\fR \fIstr\fR
This method returns the width of a string under the current font\&.
.TP
\fIobjectName\fR \fBgetCharWidth\fR \fIchar\fR
This method returns the width of a character under the current font\&.
.TP
\fIobjectName\fR \fBsetTextPosition\fR \fIx\fR \fIy\fR
Set coordinate for next text command\&.
.TP
\fIobjectName\fR \fBmoveTextPosition\fR \fIdx\fR \fIdy\fR
Increment position by \fIdx\fR, \fIdy\fR for the next text command\&.
.TP
\fIobjectName\fR \fBgetTextPosition\fR
This method returns the current text coordinate\&.
.TP
\fIobjectName\fR \fBnewLine\fR ?\fIspacing\fR?
Moves text coordinate down and resets x to where the latest
\fBsetTextPosition\fR was\&. The number of lines to move down can
be set by \fIspacing\fR\&. This may be any real number, including negative,
and defaults to the value set by \fBsetLineSpacing\fR\&.
.TP
\fIobjectName\fR \fBsetLineSpacing\fR \fIspacing\fR
Set the default line spacing used be e\&.g\&. \fBnewLine\fR\&.  Initially
the spacing is 1\&.
.TP
\fIobjectName\fR \fBgetLineSpacing\fR
Get the current default line spacing\&.
.TP
\fIobjectName\fR \fBtext\fR \fIstr\fR ?\fIoption value\fR\&.\&.\&.?
Draw text at the position defined by setTextPosition using the font defined by
setFont\&.
.RS
.TP
\fB-align\fR \fIleft|right|center\fR   (default left)
.TP
\fB-angle\fR \fIdegrees\fR   (default 0) - Orient string at the specified angle\&.
.TP
\fB-xangle\fR \fIdegrees\fR   (default 0)
.TP
\fB-yangle\fR \fIdegrees\fR   (default 0) - Apply x or y shear to the text\&.
.TP
\fB-x\fR \fIx\fR   (default 0)
.TP
\fB-y\fR \fIy\fR   (default 0) - Allow the text to be positioned without setTextPosition\&.
.TP
\fB-bg\fR \fIbool\fR   (default 0)
.TP
\fB-background\fR \fIbool\fR   (default 0)
.TP
\fB-fill\fR \fIbool\fR   (default 0)
Any of \fB-bg\fR, \fB-background\fR or \fB-fill\fR cause the text to be drawn
on a background whose color is set by setBgColor\&.
.RE
.TP
\fIobjectName\fR \fBdrawTextBox\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR \fIstr\fR ?\fIoption value\fR\&.\&.\&.?
Draw the text string \fIstr\fR wrapping at blanks and tabs so that it fits within the box defined
by \fIx\fR, \fIy\fR, \fIwidth\fR and \fIheight\fR\&. An embedded newline in \fIstr\fR causes
a new line in the output\&. If \fIstr\fR is too long to fit in the specified box, it is truncated and the unused remainder is returned\&.
.RS
.TP
\fB-align\fR \fIleft|right|center|justify\fR
Specifies the justification\&. If not given, the text is left justified\&.
.TP
\fB-linesvar\fR \fIvar\fR
Gives the name of a variable which will be set to the number of lines written\&.
.TP
\fB-dryrun\fR \fIbool\fR
If true, no changes will be made to the PDF document\&. The return
value and \fB-linesvar\fR gives information of what would happen
with the given text\&.
.RE
.TP
\fIobjectName\fR \fBgetFontMetric\fR \fImetric\fR
Get information about current font\&. The available \fImetric\fRs are
\fBascend\fR, \fBdescend\fR, \fBfixed\fR, \fBbboxb\fR,
\fBbboxt\fR and \fBheight\fR\&.
.RS
.TP
\fBascend\fR
Top of typical glyph, displacement from anchor point\&. Typically a positive number since it is above the anchor point\&.
.TP
\fBdescend\fR
Bottom of typical glyph, displacement from anchor point\&. Typically a negative number since it is below the anchor point\&.
.TP
\fBfixed\fR
Boolean which is true if this is a fixed width font\&.
.TP
\fBbboxb\fR
Bottom of Bounding Box, displacement from anchor point\&. Typically a negative number since it is below the anchor point\&.
.TP
\fBbboxt\fR
Top of Bounding Box, displacement from anchor point\&. Typically a positive number since it is above the anchor point\&.
.TP
\fBheight\fR
Height of font's Bounding Box\&.
.RE
.PP
.SS "OBJECT METHODS, IMAGES"
A limited set of image formats are directly understood by pdf4tcl, currently
JPEG and some PNG formats\&.  To use unsupported formats, use Tk and the Img
package to load and dump images to raw format which can be fed to
\fBputRawImage\fR and \fBaddRawImage\fR\&.
.TP
\fIobjectName\fR \fBputImage\fR \fIid\fR \fIx\fR \fIy\fR ?\fIoption value\fR\&.\&.\&.?
Put an image on the current page\&. The image must have been added previously by
\fBaddImage\fR or \fBaddRawImage\fR\&. The \fIid\fR is the one returned
from the add command\&.
.RS
.TP
\fB-angle\fR \fIdegrees\fR
Rotate image \fIdegrees\fR counterclockwise around the anchor point\&.
Default is 0\&.
.TP
\fB-anchor\fR \fIanchor\fR
Set the anchor point (nw, n, ne etc\&.) of the image\&.
Coordinates \fIx\fR and \fIy\fR places the anchor point, and any rotation is around the anchor point\&.
Default is nw if \fB-orient\fR is true, otherwise se\&.
.TP
\fB-height\fR \fIheight\fR
Set the height of the image\&.  Default height is one point per pixel\&.  If \fIwidth\fR is set but not \fIheight\fR,
the height is selected to preserve the aspect ratio of the image\&.
.TP
\fB-width\fR \fIwidth\fR
Set the width of the image\&.  Default width is one point per pixel\&.
If \fIheight\fR is set but not \fIwidth\fR, the width is selected to
preserve the aspect ratio of the image\&.
.RE
.TP
\fIobjectName\fR \fBputRawImage\fR \fIdata\fR \fIx\fR \fIy\fR ?\fIoption value\fR\&.\&.\&.?
Put an image on the current page\&. Works like \fBputImage\fR except that the raw image data is given directly\&.
.RS
.TP
\fB-compress\fR \fIboolean\fR
Raw data will be zlib compressed if this option is set to true\&.
Default value is the document's \fB-compress\fR setting\&.
.RE
.CS


  image create photo img1 -file image\&.gif
  set imgdata [img1 data]
  mypdf putRawImage $imgdata 60 20 -height 40

.CE
.TP
\fIobjectName\fR \fBaddImage\fR \fIfilename\fR ?\fIoption value\fR\&.\&.\&.?
Add an image to the document\&. Returns an id that can be used in subsequent
calls to \fBputImage\fR\&. Supported formats are PNG and JPEG\&.
.RS
.TP
\fB-id\fR \fIid\fR
Explicitly select an id for the image\&. The \fIid\fR must be unique within the document\&.
.TP
\fB-type\fR \fIname\fR
Set the image type\&.  This can usually be deduced from the file name, this
option helps when that is not possible\&.  This can be either "png" or "jpeg"\&.
.RE
.TP
\fIobjectName\fR \fBaddRawImage\fR \fIdata\fR ?\fIoption value\fR\&.\&.\&.?
Add an image to the document\&. Works like \fBaddImage\fR except that the raw image data is given directly\&.
.RS
.TP
\fB-compress\fR \fIboolean\fR
Raw data will be zlib compressed if this option is set to true\&.
Default value is the document's \fB-compress\fR setting\&.
.RE
.CS


  image create photo img1 -file image\&.gif
  set imgdata [img1 data]
  set id [mypdf addRawImage $imgdata]
  mypdf putImage $id 20 60 -width 100

.CE
.TP
\fIobjectName\fR \fBgetImageHeight\fR \fIid\fR
This method returns the height of the image identified by \fIid\fR\&.
.TP
\fIobjectName\fR \fBgetImageSize\fR \fIid\fR
This method returns the size of the image identified by \fIid\fR\&.  The
return value is a list of width and height\&.
.TP
\fIobjectName\fR \fBgetImageWidth\fR \fIid\fR
This method returns the width of the image identified by \fIid\fR\&.
.PP
.SS "OBJECT METHODS, COLORS"
Colors can be expressed in various formats\&. First, as a three element list
of values in the range 0\&.0 to 1\&.0\&. Second, in the format #XXXXXX where
the Xes are two hexadecimal digits per color value\&.  Third, if Tk is available,
any color accepted by winfo rgb is accepted\&.
.TP
\fIobjectName\fR \fBsetBgColor\fR \fIred\fR \fIgreen\fR \fIblue\fR
Sets the background color for text operations where -bg is true\&.
.TP
\fIobjectName\fR \fBsetBgColor\fR \fIc\fR \fIm\fR \fIy\fR \fIk\fR
Alternative calling form, to set color in CMYK color space\&.
.TP
\fIobjectName\fR \fBsetFillColor\fR \fIred\fR \fIgreen\fR \fIblue\fR
Sets the fill color for graphics operations, and the foreground color for
text operations\&.
.TP
\fIobjectName\fR \fBsetFillColor\fR \fIc\fR \fIm\fR \fIy\fR \fIk\fR
Alternative calling form, to set color in CMYK color space\&.
.TP
\fIobjectName\fR \fBsetStrokeColor\fR \fIred\fR \fIgreen\fR \fIblue\fR
Sets the stroke color for graphics operations\&.
.TP
\fIobjectName\fR \fBsetStrokeColor\fR \fIc\fR \fIm\fR \fIy\fR \fIk\fR
Alternative calling form, to set color in CMYK color space\&.
.PP
.SS "OBJECT METHODS, GRAPHICS"
.TP
\fIobjectName\fR \fBsetLineWidth\fR \fIwidth\fR
Sets the width for subsequent line drawing\&.
Line width must be a non-negative number\&.
.TP
\fIobjectName\fR \fBsetLineDash\fR ?\fIon off\fR\&.\&.\&.? ?\fIoffset\fR?
Sets the dash pattern for subsequent line drawing\&.
Offset and any elements in the dash pattern must be non-negative numbers\&.
\fIon off\fR is a series of pairs of numbers which define a
dash pattern\&. The 1st, 3rd \&.\&.\&. numbers give units to paint,
the 2nd, 4th \&.\&.\&. numbers specify unpainted gaps\&. When all numbers have
been used, the pattern is re-started from the beginning\&.
An optional last argument sets the dash offset, which defaults to 0\&.
Calling \fBsetLineDash\fR with no arguments resets the dash pattern
to a solid line\&.
.TP
\fIobjectName\fR \fBsetLineStyle\fR \fIwidth\fR \fIargs\fR
Sets the width and dash pattern for subsequent line drawing\&.
Line width and any elements in the dash pattern must be non-negative numbers\&.
\fIargs\fR is a series of numbers (not a tcl list) which define a
dash pattern\&. The 1st, 3rd \&.\&.\&. numbers give units to paint,
the 2nd, 4th \&.\&.\&. numbers specify unpainted gaps\&. When all numbers have
been used, the pattern is re-started from the beginning\&.
This method do not support offsetting the pattern, see \fBsetLineDash\fR
for a more complete method\&.
.TP
\fIobjectName\fR \fBline\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Draws a line from \fIx1,\fR \fIy1\fR to \fIx2,\fR \fIy2\fR
.TP
\fIobjectName\fR \fBcurve\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIx3\fR \fIy3\fR ?\fIx4 y4\fR?
If \fIx4,\fR \fIy4\fR are present, draws a cubic bezier from \fIx1,\fR
\fIy1\fR to \fIx4,\fR \fIy4\fR with control points \fIx2,\fR \fIy2\fR and
\fIx3,\fR \fIy3\fR\&. Otherwise draws a quadratic bezier from \fIx1,\fR
\fIy1\fR to \fIx3,\fR \fIy3\fR, with control point \fIx2,\fR
\fIy2\fR
.TP
\fIobjectName\fR \fBpolygon\fR ?\fIx y\fR\&.\&.\&.? ?\fIoption value\fR\&.\&.\&.?
Draw a polygon\&. There must be at least 3 points\&.
The polygon is closed back to the first coordinate\&.
.RS
.TP
\fB-filled\fR \fIbool\fR   (default 0)
Fill the polygon\&.
.TP
\fB-stroke\fR \fIbool\fR   (default 1)
Draw an outline of the polygon\&.
.RE
.TP
\fIobjectName\fR \fBcircle\fR \fIx\fR \fIy\fR \fIradius\fR ?\fIoption value\fR\&.\&.\&.?
Draw a circle at the given center coordinates\&.
.RS
.TP
\fB-filled\fR \fIbool\fR   (default 0)
Fill the circle\&.
.TP
\fB-stroke\fR \fIbool\fR   (default 1)
Draw an outline of the circle\&.
.RE
.TP
\fIobjectName\fR \fBoval\fR \fIx\fR \fIy\fR \fIradiusx\fR \fIradiusy\fR ?\fIoption value\fR\&.\&.\&.?
Draw an oval at the given center coordinates\&.
.RS
.TP
\fB-filled\fR \fIbool\fR   (default 0)
Fill the oval\&.
.TP
\fB-stroke\fR \fIbool\fR   (default 1)
Draw an outline of the oval\&.
.RE
.TP
\fIobjectName\fR \fBarc\fR \fIx\fR \fIy\fR \fIradiusx\fR \fIradiusy\fR \fIphi\fR \fIextend\fR ?\fIoption value\fR\&.\&.\&.?
Draw an arc, following the given oval\&. The arc starts at angle \fIphi\fR, given in degrees starting in the "east" direction, counting counter clockwise\&. The arc extends \fIextend\fR degrees\&.
.RS
.TP
\fB-filled\fR \fIbool\fR   (default 0)
Fill the arc\&.
.TP
\fB-stroke\fR \fIbool\fR   (default 1)
Draw an outline of the arc\&.
.TP
\fB-style\fR \fIarc|pieslice|chord\fR   (default \fIarc\fR)
Defines the style of the arc\&. An \fIarc\fR draws the perimeter of the arc and is never filled\&. A \fIpieslice\fR closes the arc with lines to the center of the oval\&. A \fIchord\fR closes the arc directly\&.
.RE
.TP
\fIobjectName\fR \fBarrow\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIsize\fR ?\fIangle\fR?
Draw an arrow\&. Default \fIangle\fR is 20 degrees\&.
.TP
\fIobjectName\fR \fBrectangle\fR \fIx\fR \fIy\fR \fIwidth\fR \fIheight\fR ?\fIoption value\fR\&.\&.\&.?
Draw a rectangle\&.
.RS
.TP
\fB-filled\fR \fIbool\fR   (default 0)
Fill the rectangle\&.
.TP
\fB-stroke\fR \fIbool\fR   (default 1)
Draw an outline of the rectangle\&.
.RE
.PP
.SS "OBJECT CONFIGURATION"
All pdf4tcl objects understand the options from \fBPAGE CONFIGURATION\fR,
which defines default page settings when used with a pdf4tcl object\&.
The objects also understand the following configuration options:
.TP
\fB-cmyk\fR \fIboolean\fR
If true, pdf4tcl will try to generate the document in CMYK color space\&.
See \fB::pdf4tcl::rgb2Cmyk\fR for a way to control color translation\&.
Default value is false\&.
This option can only be set at object creation\&.
.TP
\fB-compress\fR \fIboolean\fR
Pages will be zlib compressed if this option is set to true\&.
Default value is true\&.
This option can only be set at object creation\&.
.TP
\fB-file\fR \fIfilename\fR
Continuously write pdf to \fIfilename\fR instead of storing it
in memory\&.
This option can only be set at object creation\&.
.TP
\fB-unit\fR \fIdefaultunit\fR
Defines default unit for coordinates and distances\&.  Any value given without
a unit is interpreted using this unit\&.
See \fBUNITS\fR for valid units\&.
Default value is "p" as in points\&.
This option can only be set at object creation\&.
.PP
.SS "PAGE CONFIGURATION"
.TP
\fB-paper\fR \fIname\fR
The argument of this option defines the paper size\&.
The paper size may be a string like "a4", where valid values
are available through \fB::pdf4tcl::getPaperSizeList\fR\&.
Paper size may also be a two element list specifying width and height\&.
.sp
The default value of this option is "a4"\&.
.TP
\fB-landscape\fR \fIboolean\fR
If true, paper width and height are switched\&.
.sp
The default value of this option is false\&.
.TP
\fB-orient\fR \fIboolean\fR
This sets the orientation of the y axis of the coordinate system\&.
With \fB-orient\fR false, origin is in the bottom left corner\&.
With \fB-orient\fR true, origin is in the top left corner\&.
.sp
The default value of this option is true\&.
.TP
\fB-margin\fR \fIvalues\fR
The margin is a one, two or four element list of margins\&.
For one element, it specifies all margins\&.
Two elements specify left/right and top/bottom\&.
Four elements specify left, right, top and bottom\&.
.sp
The default value of this option is zero\&.
.TP
\fB-rotate\fR \fIangle\fR
This value defines a rotation angle for the display of the page\&.
Allowed values are multiples of 90\&.
.sp
The default value of this option is zero\&.
.PP
.SH EXAMPLES
.CS


  pdf4tcl::new mypdf -paper a3
  mypdf startPage
  mypdf setFont 12 Courier
  mypdf text "Hejsan" -x 50 -y 50
  mypdf write -file mypdf\&.pdf
  mypdf destroy

.CE
.SH "SEE ALSO"
doctools
.SH KEYWORDS
document, pdf
.SH COPYRIGHT
.nf
Copyright (c) 2007-2016 Peter Spjuth
Copyright (c) 2009 Yaroslav Schekin

.fi