/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkOffset3D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    public VkOffset3D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkOffset3D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return VkOffset3D.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return VkOffset3D.ny(this.address());
    }

    @NativeType(value="int32_t")
    public int z() {
        return VkOffset3D.nz(this.address());
    }

    public VkOffset3D x(@NativeType(value="int32_t") int value) {
        VkOffset3D.nx(this.address(), value);
        return this;
    }

    public VkOffset3D y(@NativeType(value="int32_t") int value) {
        VkOffset3D.ny(this.address(), value);
        return this;
    }

    public VkOffset3D z(@NativeType(value="int32_t") int value) {
        VkOffset3D.nz(this.address(), value);
        return this;
    }

    public VkOffset3D set(int x, int y, int z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public VkOffset3D set(VkOffset3D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkOffset3D malloc() {
        return (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkOffset3D calloc() {
        return (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkOffset3D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkOffset3D create(long address) {
        return (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)address);
    }

    @Nullable
    public static VkOffset3D createSafe(long address) {
        return address == 0L ? null : (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkOffset3D.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkOffset3D.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkOffset3D.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkOffset3D.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkOffset3D.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkOffset3D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkOffset3D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkOffset3D mallocStack() {
        return VkOffset3D.mallocStack(MemoryStack.stackGet());
    }

    public static VkOffset3D callocStack() {
        return VkOffset3D.callocStack(MemoryStack.stackGet());
    }

    public static VkOffset3D mallocStack(MemoryStack stack) {
        return (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkOffset3D callocStack(MemoryStack stack) {
        return (VkOffset3D)VkOffset3D.wrap(VkOffset3D.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkOffset3D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkOffset3D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkOffset3D.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkOffset3D.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static int nz(long struct) {
        return UNSAFE.getInt(null, struct + (long)Z);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = VkOffset3D.__struct((Struct.Member[])new Struct.Member[]{VkOffset3D.__member((int)4), VkOffset3D.__member((int)4), VkOffset3D.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkOffset3D, Buffer>
    implements NativeResource {
        private static final VkOffset3D ELEMENT_FACTORY = VkOffset3D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkOffset3D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return VkOffset3D.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return VkOffset3D.ny(this.address());
        }

        @NativeType(value="int32_t")
        public int z() {
            return VkOffset3D.nz(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            VkOffset3D.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            VkOffset3D.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="int32_t") int value) {
            VkOffset3D.nz(this.address(), value);
            return this;
        }
    }
}

