/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DeepImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CHANNEL_NAMES;
    public static final int IMAGE;
    public static final int OFFSET_TABLE;
    public static final int NUM_CHANNELS;
    public static final int WIDTH;
    public static final int HEIGHT;

    public DeepImage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), DeepImage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const **")
    public PointerBuffer channel_names() {
        return DeepImage.nchannel_names(this.address());
    }

    @NativeType(value="float ***")
    public PointerBuffer image() {
        return DeepImage.nimage(this.address());
    }

    @NativeType(value="int **")
    public PointerBuffer offset_table(int capacity) {
        return DeepImage.noffset_table(this.address(), capacity);
    }

    public int num_channels() {
        return DeepImage.nnum_channels(this.address());
    }

    public int width() {
        return DeepImage.nwidth(this.address());
    }

    public int height() {
        return DeepImage.nheight(this.address());
    }

    public DeepImage channel_names(@NativeType(value="char const **") PointerBuffer value) {
        DeepImage.nchannel_names(this.address(), value);
        return this;
    }

    public DeepImage image(@NativeType(value="float ***") PointerBuffer value) {
        DeepImage.nimage(this.address(), value);
        return this;
    }

    public DeepImage offset_table(@NativeType(value="int **") PointerBuffer value) {
        DeepImage.noffset_table(this.address(), value);
        return this;
    }

    public DeepImage num_channels(int value) {
        DeepImage.nnum_channels(this.address(), value);
        return this;
    }

    public DeepImage width(int value) {
        DeepImage.nwidth(this.address(), value);
        return this;
    }

    public DeepImage height(int value) {
        DeepImage.nheight(this.address(), value);
        return this;
    }

    public DeepImage set(PointerBuffer channel_names, PointerBuffer image, PointerBuffer offset_table, int num_channels, int width, int height) {
        this.channel_names(channel_names);
        this.image(image);
        this.offset_table(offset_table);
        this.num_channels(num_channels);
        this.width(width);
        this.height(height);
        return this;
    }

    public DeepImage set(DeepImage src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static DeepImage malloc() {
        return (DeepImage)DeepImage.wrap(DeepImage.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static DeepImage calloc() {
        return (DeepImage)DeepImage.wrap(DeepImage.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static DeepImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (DeepImage)DeepImage.wrap(DeepImage.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static DeepImage create(long address) {
        return (DeepImage)DeepImage.wrap(DeepImage.class, (long)address);
    }

    @Nullable
    public static DeepImage createSafe(long address) {
        return address == 0L ? null : (DeepImage)DeepImage.wrap(DeepImage.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)DeepImage.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)DeepImage.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)DeepImage.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = DeepImage.__create((int)capacity, (int)SIZEOF);
        return (Buffer)DeepImage.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)DeepImage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)DeepImage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static DeepImage mallocStack() {
        return DeepImage.mallocStack(MemoryStack.stackGet());
    }

    public static DeepImage callocStack() {
        return DeepImage.callocStack(MemoryStack.stackGet());
    }

    public static DeepImage mallocStack(MemoryStack stack) {
        return (DeepImage)DeepImage.wrap(DeepImage.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DeepImage callocStack(MemoryStack stack) {
        return (DeepImage)DeepImage.wrap(DeepImage.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return DeepImage.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return DeepImage.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)DeepImage.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)DeepImage.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nchannel_names(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)CHANNEL_NAMES)), (int)DeepImage.nnum_channels(struct));
    }

    public static PointerBuffer nimage(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)IMAGE)), (int)DeepImage.nnum_channels(struct));
    }

    public static PointerBuffer noffset_table(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)OFFSET_TABLE)), (int)capacity);
    }

    public static int nnum_channels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_CHANNELS);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static void nchannel_names(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CHANNEL_NAMES), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nimage(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void noffset_table(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OFFSET_TABLE), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nnum_channels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_CHANNELS, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CHANNEL_NAMES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)IMAGE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)OFFSET_TABLE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            DeepImage.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = DeepImage.__struct((Struct.Member[])new Struct.Member[]{DeepImage.__member((int)POINTER_SIZE), DeepImage.__member((int)POINTER_SIZE), DeepImage.__member((int)POINTER_SIZE), DeepImage.__member((int)4), DeepImage.__member((int)4), DeepImage.__member((int)4), DeepImage.__padding((int)4, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CHANNEL_NAMES = layout.offsetof(0);
        IMAGE = layout.offsetof(1);
        OFFSET_TABLE = layout.offsetof(2);
        NUM_CHANNELS = layout.offsetof(3);
        WIDTH = layout.offsetof(4);
        HEIGHT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<DeepImage, Buffer>
    implements NativeResource {
        private static final DeepImage ELEMENT_FACTORY = DeepImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected DeepImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const **")
        public PointerBuffer channel_names() {
            return DeepImage.nchannel_names(this.address());
        }

        @NativeType(value="float ***")
        public PointerBuffer image() {
            return DeepImage.nimage(this.address());
        }

        @NativeType(value="int **")
        public PointerBuffer offset_table(int capacity) {
            return DeepImage.noffset_table(this.address(), capacity);
        }

        public int num_channels() {
            return DeepImage.nnum_channels(this.address());
        }

        public int width() {
            return DeepImage.nwidth(this.address());
        }

        public int height() {
            return DeepImage.nheight(this.address());
        }

        public Buffer channel_names(@NativeType(value="char const **") PointerBuffer value) {
            DeepImage.nchannel_names(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="float ***") PointerBuffer value) {
            DeepImage.nimage(this.address(), value);
            return this;
        }

        public Buffer offset_table(@NativeType(value="int **") PointerBuffer value) {
            DeepImage.noffset_table(this.address(), value);
            return this;
        }

        public Buffer num_channels(int value) {
            DeepImage.nnum_channels(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            DeepImage.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            DeepImage.nheight(this.address(), value);
            return this;
        }
    }
}

