/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.discovery;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.Output;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.logstash.plugins.PluginLookup;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class PluginRegistry {
    private static final Map<String, Class<Input>> INPUTS = new HashMap<String, Class<Input>>();
    private static final Map<String, Class<Filter>> FILTERS = new HashMap<String, Class<Filter>>();
    private static final Map<String, Class<Output>> OUTPUTS = new HashMap<String, Class<Output>>();
    private static final Map<String, Class<Codec>> CODECS = new HashMap<String, Class<Codec>>();

    private PluginRegistry() {
    }

    private static void discoverPlugins() {
        Reflections reflections = new Reflections("org.logstash.plugins", new Scanner[0]);
        Set annotated = reflections.getTypesAnnotatedWith(LogstashPlugin.class);
        block0: for (Class cls : annotated) {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!(annotation instanceof LogstashPlugin)) continue;
                String name = ((LogstashPlugin)annotation).name();
                if (Filter.class.isAssignableFrom(cls)) {
                    FILTERS.put(name, cls);
                }
                if (Output.class.isAssignableFrom(cls)) {
                    OUTPUTS.put(name, cls);
                }
                if (Input.class.isAssignableFrom(cls)) {
                    INPUTS.put(name, cls);
                }
                if (!Codec.class.isAssignableFrom(cls)) continue block0;
                CODECS.put(name, cls);
                continue block0;
            }
        }
    }

    public static Class<?> getPluginClass(PluginLookup.PluginType pluginType, String pluginName) {
        if (pluginType == PluginLookup.PluginType.FILTER) {
            return PluginRegistry.getFilterClass(pluginName);
        }
        if (pluginType == PluginLookup.PluginType.OUTPUT) {
            return PluginRegistry.getOutputClass(pluginName);
        }
        if (pluginType == PluginLookup.PluginType.INPUT) {
            return PluginRegistry.getInputClass(pluginName);
        }
        if (pluginType == PluginLookup.PluginType.CODEC) {
            return PluginRegistry.getCodecClass(pluginName);
        }
        throw new IllegalStateException("Unknown plugin type: " + (Object)((Object)pluginType));
    }

    public static Class<Input> getInputClass(String name) {
        return INPUTS.get(name);
    }

    public static Class<Filter> getFilterClass(String name) {
        return FILTERS.get(name);
    }

    public static Class<Codec> getCodecClass(String name) {
        return CODECS.get(name);
    }

    public static Class<Output> getOutputClass(String name) {
        return OUTPUTS.get(name);
    }

    public static Codec getCodec(String name, Configuration configuration, Context context) {
        if (name != null && CODECS.containsKey(name)) {
            return PluginRegistry.instantiateCodec(CODECS.get(name), configuration, context);
        }
        return null;
    }

    private static Codec instantiateCodec(Class clazz, Configuration configuration, Context context) {
        try {
            Constructor constructor = clazz.getConstructor(Configuration.class, Context.class);
            return (Codec)constructor.newInstance(configuration, context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate codec", e);
        }
    }

    static {
        PluginRegistry.discoverPlugins();
    }
}

