/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.ReplyTracker;
import net.i2p.i2ptunnel.socks.SOCKSHeader;
import net.i2p.i2ptunnel.socks.SOCKSUDPUnwrapper;
import net.i2p.i2ptunnel.socks.SOCKSUDPWrapper;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.i2ptunnel.udp.UDPSink;
import net.i2p.i2ptunnel.udp.UDPSource;

public class SOCKSUDPPort
implements Source,
Sink {
    private UDPSink udpsink;
    private UDPSource udpsource;
    private SOCKSUDPWrapper wrapper;
    private SOCKSUDPUnwrapper unwrapper;
    private ReplyTracker<SOCKSUDPPort> udptracker;

    public SOCKSUDPPort(InetAddress host, int port, Map<Destination, SOCKSUDPPort> replyMap) {
        ConcurrentHashMap<Destination, SOCKSHeader> cache = new ConcurrentHashMap<Destination, SOCKSHeader>(4);
        this.wrapper = new SOCKSUDPWrapper(cache);
        this.udpsink = new UDPSink(host, port);
        this.wrapper.setSink(this.udpsink);
        DatagramSocket sock = this.udpsink.getSocket();
        this.udpsource = new UDPSource(sock);
        this.unwrapper = new SOCKSUDPUnwrapper(cache);
        this.udpsource.setSink(this.unwrapper);
        this.udptracker = new ReplyTracker<SOCKSUDPPort>(this, replyMap);
        this.unwrapper.setSink(this.udptracker);
    }

    public int getPort() {
        return this.udpsink.getPort();
    }

    @Override
    public void setSink(Sink sink) {
        this.udptracker.setSink(sink);
    }

    @Override
    public void start() {
        this.udpsource.start();
    }

    public void stop() {
        this.udpsink.stop();
        this.udpsource.stop();
    }

    @Override
    public void send(Destination from, byte[] data) {
        this.wrapper.send(from, data);
    }
}

