/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.jvm.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmClass;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmElementProvider;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacade;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiFacadeImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class JvmFacadeImpl
implements JvmFacade {
    private static final Logger LOG = Logger.getInstance(JvmFacadeImpl.class);
    private final DumbService myDumbService;
    private final JavaPsiFacadeImpl myJavaPsiFacade;
    private final JvmElementProvider[] myElementProviders;
    private final Map<GlobalSearchScope, Map<String, List<JvmClass>>> myClassCache;

    public JvmFacadeImpl(@NotNull Project project, MessageBus bus) {
        if (project == null) {
            JvmFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myClassCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        this.myDumbService = DumbService.getInstance(project);
        this.myJavaPsiFacade = (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(project);
        this.myElementProviders = JvmElementProvider.EP_NAME.getExtensions(project);
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, () -> this.myClassCache.clear());
        }
    }

    @NotNull
    public List<JvmClass> findClassesWithoutJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JvmFacadeImpl.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            JvmFacadeImpl.$$$reportNull$$$0(9);
        }
        ArrayList<? extends JvmClass> result2 = null;
        for (JvmElementProvider provider : this.filteredProviders()) {
            List<? extends JvmClass> providedClasses = provider.getClasses(qualifiedName, scope2);
            if (providedClasses.isEmpty()) continue;
            JvmFacadeImpl.assertNotNullClasses(provider, providedClasses);
            if (result2 == null) {
                result2 = new ArrayList<JvmClass>(providedClasses);
                continue;
            }
            result2.addAll(providedClasses);
        }
        List<JvmClass> list2 = result2 == null ? Collections.emptyList() : result2;
        if (list2 == null) {
            JvmFacadeImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static void assertNotNullClasses(@NotNull JvmElementProvider provider, @NotNull List<? extends JvmClass> classes2) {
        if (provider == null) {
            JvmFacadeImpl.$$$reportNull$$$0(15);
        }
        if (classes2 == null) {
            JvmFacadeImpl.$$$reportNull$$$0(16);
        }
        for (JvmClass jvmClass : classes2) {
            LOG.assertTrue(jvmClass != null, "Provider " + provider + "returned null JvmClass");
        }
    }

    @NotNull
    private List<JvmElementProvider> filteredProviders() {
        List<JvmElementProvider> list2 = this.myDumbService.filterByDumbAwareness(this.myElementProviders);
        if (list2 == null) {
            JvmFacadeImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/jvm/facade/JvmFacadeImpl";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/jvm/facade/JvmFacadeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJavaFacade";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassesWithJavaFacade";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJavaFacade";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJavaFacade";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sortByScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assertNotNullClasses";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

