/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.carbon.OSType;
import org.catacombae.hfsexplorer.types.carbon.Point;

/** This class was generated by CStructToJavaClass. */
public class FInfo implements StructElements {
    /*
     * struct FInfo
     * size: 16 bytes
     * description: 
     * 
     * BP  Size  Type    Identifier  Description                                                                                      
     * -------------------------------------------------------------------------------------------------------------------------------
     * 0   4     OSType  fdType      File type.                                                                                       
     * 4   4     OSType  fdCreator   The signature of the application that created the file.                                          
     * 8   2     UInt16  fdFlags     Finder flags. See Finder Flags.                                                                
     * 10  4     Point   fdLocation  The location--specified in coordinates local to the window--of the file's icon within its window.
     * 14  2     SInt16  fdFldr      The window in which the file's icon appears; this information is meaningful only to the Finder.  
     */

    public static final int STRUCTSIZE = 16;

    private final OSType fdType;
    private final OSType fdCreator;
    private final byte[] fdFlags = new byte[2];
    private final Point fdLocation;
    private final byte[] fdFldr = new byte[2];

    public FInfo(byte[] data, int offset) {
        fdType = new OSType(data, offset + 0);
        fdCreator = new OSType(data, offset + 4);
        System.arraycopy(data, offset + 8, fdFlags, 0, 2);
        fdLocation = new Point(data, offset + 10);
        System.arraycopy(data, offset + 14, fdFldr, 0, 2);
    }
    
    public static int length() {
        return STRUCTSIZE;
    }

    /** File type. */
    public OSType getFdType() {
        return fdType;
    }

    /** The signature of the application that created the file. */
    public OSType getFdCreator() {
        return fdCreator;
    }

    /** Finder flags. See Finder Flags. */
    public short getFdFlags() {
        return Util.readShortBE(fdFlags);
    }

    /** The location--specified in coordinates local to the window--of the file's icon within its window. */
    public Point getFdLocation() {
        return fdLocation;
    }

    /** The window in which the file's icon appears; this information is meaningful only to the Finder. */
    public short getFdFldr() {
        return Util.readShortBE(fdFldr);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " fdType: ");
        getFdType().print(ps, prefix + "  ");
        ps.println(prefix + " fdCreator: ");
        getFdCreator().print(ps, prefix + "  ");
        ps.println(prefix + " fdFlags: " + getFdFlags());
        ps.println(prefix + " fdLocation: ");
        getFdLocation().print(ps, prefix + "  ");
        ps.println(prefix + " fdFldr: " + getFdFldr());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "FInfo:");
        printFields(ps, prefix);
    }
    
    public byte[] getBytes() {
        byte[] result = new byte[length()];
        int offset = 0;
        {
            byte[] tempData = this.fdType.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        }
        {
            byte[] tempData = this.fdCreator.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        }
        System.arraycopy(this.fdFlags, 0, result, offset, this.fdFlags.length); offset += this.fdFlags.length;
        {
            byte[] tempData = this.fdLocation.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        }
        System.arraycopy(this.fdFldr, 0, result, offset, this.fdFldr.length); offset += this.fdFldr.length;
        return result;
    }

    @Override
    public Dictionary getStructElements() {
        DictionaryBuilder db = new DictionaryBuilder(FInfo.class.getSimpleName());
        
        db.add("fdType", fdType.getStructElements());
        db.add("fdCreator", fdCreator.getStructElements());
        db.addUIntBE("fdFlags", fdFlags);
        db.add("fdLocation", fdLocation.getStructElements());
        db.addSIntBE("fdFldr", fdFldr);
        
        return db.getResult();
    }
}
