/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib;

import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.hfsexplorer.win32.WritableWin32File;
import org.catacombae.io.ConcatenatedStream;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;

public class WindowsDeviceDataLocator
extends DataLocator {
    private final String devicePath;
    private final Long pos;
    private final Long len;

    public WindowsDeviceDataLocator(String pDevicePath) {
        this.devicePath = pDevicePath;
        this.pos = null;
        this.len = null;
    }

    public WindowsDeviceDataLocator(String pDevicePath, long pPos, long pLen) {
        this.devicePath = pDevicePath;
        this.pos = pPos;
        this.len = pLen;
    }

    public ReadableRandomAccessStream createReadOnlyFile() {
        WindowsLowLevelIO llf = new WindowsLowLevelIO(this.devicePath);
        if (this.pos != null && this.len != null) {
            return new ReadableConcatenatedStream((ReadableRandomAccessStream)llf, this.pos.longValue(), this.len.longValue());
        }
        return llf;
    }

    public RandomAccessStream createReadWriteFile() {
        WritableWin32File wllf = new WritableWin32File(this.devicePath);
        if (this.pos != null && this.len != null) {
            return new ConcatenatedStream((RandomAccessStream)wllf, this.pos.longValue(), this.len.longValue());
        }
        return wllf;
    }

    public boolean isWritable() {
        return true;
    }
}

