/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.catacombae.hfsexplorer.SpeedUnitUtils;
import org.jdesktop.layout.GroupLayout;

public class ExtractProgressPanel
extends JPanel {
    private final DecimalFormat progressFormatter = new DecimalFormat("0.0");
    private final DecimalFormat fileSizeFormatter = new DecimalFormat("0.00");
    public JButton cancelButton;
    private JLabel currentFilenameLabel;
    private JPanel internalPanel;
    private JProgressBar progressBar;
    private JToggleButton showSettingsButton;

    public ExtractProgressPanel() {
        this.initComponents();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(Integer.MAX_VALUE);
    }

    public void updateCalculateDir(final String dirname) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtractProgressPanel.this.currentFilenameLabel.setText("Processing: " + dirname);
                ExtractProgressPanel.this.currentFilenameLabel.setToolTipText(dirname);
            }
        });
    }

    public void updateTotalProgress(final double fraction, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtractProgressPanel.this.progressBar.setValue((int)(fraction * 2.147483647E9));
                ExtractProgressPanel.this.progressBar.setString(ExtractProgressPanel.this.progressFormatter.format(100.0 * fraction) + "% (" + message + ")");
            }
        });
    }

    public void updateCurrentDir(final String dirname) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtractProgressPanel.this.currentFilenameLabel.setText("Extracting: " + dirname);
                ExtractProgressPanel.this.currentFilenameLabel.setToolTipText(dirname);
            }
        });
    }

    public void updateCurrentFile(final String filename, final long fileSize) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtractProgressPanel.this.currentFilenameLabel.setText("Extracting: " + filename + " (" + SpeedUnitUtils.bytesToBinaryUnit((long)fileSize, (DecimalFormat)ExtractProgressPanel.this.fileSizeFormatter) + ")");
                ExtractProgressPanel.this.currentFilenameLabel.setToolTipText(filename);
            }
        });
    }

    public void addShowSettingsButtonListener(ActionListener al) {
        this.showSettingsButton.addActionListener(al);
    }

    public boolean getShowSettingsButtonSelected() {
        return this.showSettingsButton.isSelected();
    }

    private void initComponents() {
        this.internalPanel = new JPanel();
        this.currentFilenameLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.showSettingsButton = new JToggleButton();
        this.currentFilenameLabel.setText("Calculating selection size...");
        this.progressBar.setString("Calculating selection size...");
        this.progressBar.setStringPainted(true);
        this.cancelButton.setText("Cancel");
        this.showSettingsButton.setText(">>");
        GroupLayout internalPanelLayout = new GroupLayout((Container)this.internalPanel);
        this.internalPanel.setLayout((LayoutManager)internalPanelLayout);
        internalPanelLayout.setHorizontalGroup((GroupLayout.Group)internalPanelLayout.createParallelGroup(1).add((Component)this.currentFilenameLabel, -2, 400, -2).add((GroupLayout.Group)internalPanelLayout.createSequentialGroup().add((Component)this.progressBar, -2, 274, -2).addPreferredGap(0).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.showSettingsButton)));
        internalPanelLayout.setVerticalGroup((GroupLayout.Group)internalPanelLayout.createParallelGroup(1).add((GroupLayout.Group)internalPanelLayout.createSequentialGroup().add((Component)this.currentFilenameLabel).addPreferredGap(0).add((GroupLayout.Group)internalPanelLayout.createParallelGroup(3).add((Component)this.progressBar, -1, 24, Short.MAX_VALUE).add((Component)this.cancelButton).add((Component)this.showSettingsButton))));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.internalPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.internalPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

