/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import ghidra.app.plugin.core.byteviewer.ByteField;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.util.HighlightProvider;
import ghidra.program.model.address.AddressOutOfBoundsException;
import java.awt.Color;
import java.awt.FontMetrics;
import java.math.BigInteger;

class FieldFactory {
    private IndexMap indexMap;
    private ByteBlockSet blockSet;
    private DataFormatModel model;
    private int charWidth;
    private int fieldOffset;
    private FontMetrics fm;
    private int width;
    private String noValueStr;
    private String readErrorStr;
    private int startX;
    private Color editColor;
    private Color separatorColor;
    private int unitByteSize;
    private HighlightFactory highlightFactory;

    FieldFactory(DataFormatModel model, int bytesPerLine, int fieldOffset, FontMetrics fm, HighlightProvider highlightProvider) {
        this.model = model;
        this.fieldOffset = fieldOffset;
        this.fm = fm;
        this.highlightFactory = new SimpleHighlightFactory(highlightProvider);
        this.charWidth = fm.charWidth('W');
        this.width = this.charWidth * model.getDataUnitSymbolSize();
        this.editColor = ByteViewerComponentProvider.DEFAULT_EDIT_COLOR;
        this.separatorColor = ByteViewerComponentProvider.DEFAULT_MISSING_VALUE_COLOR;
        this.unitByteSize = model.getUnitByteSize();
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getStartX() {
        return this.startX;
    }

    public Field getField(BigInteger index) {
        if (this.indexMap == null) {
            return null;
        }
        ByteBlockInfo info = this.indexMap.getBlockInfo(index, this.fieldOffset);
        if (info == null) {
            if (this.indexMap.showSeparator(index)) {
                ByteField bf = new ByteField(this.noValueStr, this.fm, this.startX, this.width, false, this.fieldOffset, index, this.highlightFactory);
                bf.setForeground(this.separatorColor);
                return bf;
            }
            return null;
        }
        try {
            ByteBlock block = info.getBlock();
            BigInteger offset = info.getOffset();
            if (!block.hasValue(offset)) {
                return this.getByteField(this.readErrorStr, index);
            }
            String str = this.model.getDataRepresentation(block, offset);
            ByteField bf = new ByteField(str, this.fm, this.startX, this.width, false, this.fieldOffset, index, this.highlightFactory);
            if (this.blockSet.isChanged(block, offset, this.unitByteSize)) {
                bf.setForeground(this.editColor);
            }
            return bf;
        }
        catch (ByteBlockAccessException e) {
            return this.getByteField(this.readErrorStr, index);
        }
        catch (AddressOutOfBoundsException e) {
            return this.getByteField(this.noValueStr, index);
        }
        catch (IndexOutOfBoundsException e) {
            return this.getByteField(this.noValueStr, index);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public FontMetrics getMetrics() {
        return this.fm;
    }

    void setIndexMap(IndexMap indexMap) {
        this.indexMap = indexMap;
        if (indexMap != null) {
            this.noValueStr = this.getString(".");
            this.readErrorStr = this.getString("?");
            this.blockSet = indexMap.getByteBlockSet();
        } else {
            this.blockSet = null;
        }
    }

    int getFieldOffset() {
        return this.fieldOffset;
    }

    int getColumnPosition(ByteBlock block, int byteOffset) {
        return this.model.getColumnPosition(block, byteOffset);
    }

    void setEditColor(Color c) {
        this.editColor = c;
    }

    void setSeparatorColor(Color c) {
        this.separatorColor = c;
    }

    private String getString(String value) {
        StringBuffer sb = new StringBuffer();
        int count = this.model.getDataUnitSymbolSize();
        for (int i = 0; i < count; ++i) {
            sb.append(value);
        }
        return sb.toString();
    }

    private ByteField getByteField(String value, BigInteger index) {
        return new ByteField(value, this.fm, this.startX, this.width, false, this.fieldOffset, index, this.highlightFactory);
    }

    static class SimpleHighlightFactory
    implements HighlightFactory {
        private final HighlightProvider provider;

        public SimpleHighlightFactory(HighlightProvider provider) {
            this.provider = provider;
        }

        public Highlight[] getHighlights(Field field, String text, int cursorTextOffset) {
            return this.provider.getHighlights(text, null, null, -1);
        }
    }
}

