/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class ShortField
extends Field {
    private short value;

    public ShortField() {
    }

    public ShortField(short s) {
        this.value = s;
    }

    @Override
    public short getShortValue() {
        return this.value;
    }

    @Override
    public void setShortValue(short value) {
        this.value = value;
    }

    @Override
    int length() {
        return 2;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putShort(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.value = buf.getShort(offset);
        return offset + 2;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 2;
    }

    @Override
    protected byte getFieldType() {
        return 1;
    }

    public String toString() {
        return "ShortField: " + Short.toString(this.value);
    }

    @Override
    public String getValueAsString() {
        return Integer.toHexString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ShortField)) {
            return false;
        }
        return ((ShortField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        ShortField f = (ShortField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public Field newField(Field fieldValue) {
        if (fieldValue.isVariableLength()) {
            throw new AssertException();
        }
        return new ShortField((short)fieldValue.getLongValue());
    }

    @Override
    public Field newField() {
        return new ShortField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.value = (short)value;
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{(byte)(this.value >> 8), (byte)this.value};
    }

    @Override
    public int hashCode() {
        return this.value;
    }
}

