/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import java.io.IOException;

public class DatabaseUtils {
    private DatabaseUtils() {
    }

    public static void moveRecords(Table table, long oldStart, long newStart, long size) throws IOException {
        Record rec;
        if (oldStart == newStart) {
            return;
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("size must be > 0");
        }
        if (oldStart + size - 1L < 0L || newStart + size - 1L < 0L) {
            throw new IllegalArgumentException("Illegal range: end range overflow");
        }
        DBHandle tmp = new DBHandle();
        Table tmpTable = tmp.createTable("tmp", table.getSchema());
        long txID = tmp.startTransaction();
        long keyDiff = newStart - oldStart;
        RecordIterator it = table.iterator(oldStart, oldStart + size - 1L, oldStart);
        while (it.hasNext()) {
            rec = it.next();
            rec.setKey(rec.getKey() + keyDiff);
            tmpTable.putRecord(rec);
        }
        table.deleteRecords(oldStart, oldStart + size - 1L);
        table.deleteRecords(newStart, newStart + size - 1L);
        it = tmpTable.iterator(newStart, newStart + size - 1L, newStart);
        while (it.hasNext()) {
            rec = it.next();
            table.putRecord(rec);
        }
        tmp.endTransaction(txID, false);
        tmp.close();
    }
}

