/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.app.util.recognizer.ArjRecognizer;
import ghidra.app.util.recognizer.Bzip2Recognizer;
import ghidra.app.util.recognizer.CHMRecognizer;
import ghidra.app.util.recognizer.CabarcRecognizer;
import ghidra.app.util.recognizer.CramFSRecognizer;
import ghidra.app.util.recognizer.DebRecognizer;
import ghidra.app.util.recognizer.LhaRecognizer;
import ghidra.app.util.recognizer.MSWIMRecognizer;
import ghidra.app.util.recognizer.RPMRecognizer;
import ghidra.app.util.recognizer.RarRecognizer;
import ghidra.app.util.recognizer.Recognizer;
import ghidra.app.util.recognizer.SevenZipRecognizer;
import ghidra.app.util.recognizer.UnixCompressRecognizer;
import ghidra.app.util.recognizer.VHDRecognizer;
import ghidra.app.util.recognizer.XZRecognizer;
import ghidra.app.util.recognizer.XarRecognizer;
import ghidra.file.formats.sevenzip.SevenZipFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryWithFile;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SevenZipFileSystemFactory
implements GFileSystemFactoryWithFile<SevenZipFileSystem>,
GFileSystemProbeBytesOnly {
    private List<Recognizer> recognizers = List.of(new SevenZipRecognizer(), new XZRecognizer(), new Bzip2Recognizer(), new MSWIMRecognizer(), new ArjRecognizer(), new CabarcRecognizer(), new CHMRecognizer(), new CramFSRecognizer(), new DebRecognizer(), new LhaRecognizer(), new RarRecognizer(), new RPMRecognizer(), new VHDRecognizer(), new XarRecognizer(), new UnixCompressRecognizer());
    private final int recognizerBytesRequired;

    public SevenZipFileSystemFactory() {
        int max = 0;
        for (Recognizer recognizer : this.recognizers) {
            max = Math.max(max, recognizer.numberOfBytesRequired());
        }
        this.recognizerBytesRequired = max;
    }

    public int getBytesRequired() {
        return this.recognizerBytesRequired;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        for (Recognizer recognizer : this.recognizers) {
            String recognized = recognizer.recognize(startBytes);
            if (recognized == null) continue;
            return true;
        }
        return false;
    }

    public SevenZipFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        SevenZipFileSystem fs = new SevenZipFileSystem(targetFSRL);
        try {
            fs.mount(containerFile, monitor);
            return fs;
        }
        catch (IOException ioe) {
            fs.close();
            throw ioe;
        }
    }
}

