/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.Match;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class SequenceSearchState
implements Comparable<SequenceSearchState> {
    private SequenceSearchState parent;
    private ArrayList<DittedBitSequence> possible;
    private ArrayList<DittedBitSequence> success;
    private SequenceSearchState[] trans;

    public SequenceSearchState(SequenceSearchState par) {
        this.parent = par;
        this.possible = new ArrayList();
        this.success = null;
        this.trans = null;
    }

    public int getMaxSequenceSize() {
        int max = 0;
        for (int i = 0; i < this.possible.size(); ++i) {
            int val = this.possible.get(i).getSize();
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    public void addSequence(DittedBitSequence pat, int pos) {
        this.possible.add(pat);
        if (pos == pat.getSize()) {
            if (this.success == null) {
                this.success = new ArrayList();
            }
            this.success.add(pat);
        }
    }

    public void sortSequences() {
        Comparator<DittedBitSequence> comp = new Comparator<DittedBitSequence>(){

            @Override
            public int compare(DittedBitSequence o1, DittedBitSequence o2) {
                return o1.getIndex() - o2.getIndex();
            }
        };
        Collections.sort(this.possible, comp);
        if (this.success != null) {
            Collections.sort(this.success, comp);
        }
    }

    @Override
    public int compareTo(SequenceSearchState o) {
        int i = 0;
        while (true) {
            int indthem;
            if (this.possible.size() <= i) {
                if (o.possible.size() <= i) {
                    return 0;
                }
                return -1;
            }
            if (o.possible.size() <= i) {
                return 1;
            }
            int indus = this.possible.get(i).getIndex();
            if (indus != (indthem = o.possible.get(i).getIndex())) {
                return indus < indthem ? -1 : 1;
            }
            ++i;
        }
    }

    private void buildSingleTransition(ArrayList<SequenceSearchState> all, int pos, int val) {
        SequenceSearchState newstate = null;
        for (int i = 0; i < this.possible.size(); ++i) {
            DittedBitSequence curpat = this.possible.get(i);
            if (!curpat.isMatch(pos, val)) continue;
            if (newstate == null) {
                newstate = new SequenceSearchState(this);
            }
            newstate.addSequence(curpat, pos + 1);
        }
        this.trans[val] = newstate;
        if (newstate != null) {
            newstate.sortSequences();
            all.add(newstate);
        }
    }

    private void exportSuccess(ArrayList<Match> match, int offset) {
        for (int i = 0; i < this.success.size(); ++i) {
            Match newmatch = new Match(this.success.get(i), offset);
            match.add(newmatch);
        }
    }

    private void merge(SequenceSearchState op) {
        SequenceSearchState parent = op.parent;
        for (int i = 0; i < 256; ++i) {
            if (parent.trans[i] != op) continue;
            parent.trans[i] = this;
        }
        if (op.success != null) {
            if (this.success == null) {
                this.success = op.success;
            } else {
                ArrayList<DittedBitSequence> tmp = new ArrayList<DittedBitSequence>();
                int i = 0;
                int j = 0;
                int curpat = -1;
                int thispat = this.success.get((int)i).index;
                int oppat = op.success.get((int)j).index;
                while (i < this.success.size() || j < op.success.size()) {
                    if (thispat == oppat) {
                        if (curpat != thispat) {
                            tmp.add(this.success.get(i));
                            curpat = thispat;
                        }
                        thispat = ++i == this.success.size() ? 10000000 : this.success.get((int)i).index;
                        oppat = j == op.success.size() ? 10000000 : op.success.get((int)(++j)).index;
                        continue;
                    }
                    if (thispat < oppat) {
                        if (curpat != thispat) {
                            tmp.add(this.success.get(i));
                            curpat = thispat;
                        }
                        thispat = ++i == this.success.size() ? 10000000 : this.success.get((int)i).index;
                        continue;
                    }
                    if (curpat != oppat) {
                        tmp.add(op.success.get(j));
                        curpat = oppat;
                    }
                    oppat = ++j == op.success.size() ? 10000000 : op.success.get((int)j).index;
                }
                this.success = tmp;
            }
        }
    }

    public void sequenceMatch(byte[] bytearray, int numbytes, ArrayList<Match> match) {
        int subindex = 0;
        SequenceSearchState curstate = this;
        do {
            if (curstate.success != null) {
                curstate.exportSuccess(match, 0);
            }
            if (subindex >= numbytes) {
                return;
            }
            curstate = curstate.trans[0xFF & bytearray[subindex]];
            ++subindex;
        } while (curstate != null);
    }

    public void apply(byte[] buffer, ArrayList<Match> match) {
        block0: for (int offset = 0; offset < buffer.length; ++offset) {
            SequenceSearchState curstate = this;
            int subindex = offset;
            do {
                if (curstate.success != null) {
                    curstate.exportSuccess(match, offset);
                }
                if (subindex >= buffer.length) continue block0;
                curstate = curstate.trans[0xFF & buffer[subindex]];
                ++subindex;
            } while (curstate != null);
        }
    }

    public void apply(InputStream in, ArrayList<Match> match, TaskMonitor monitor) throws IOException {
        this.apply(in, -1L, match, monitor);
    }

    public void apply(InputStream in, long maxBytes, ArrayList<Match> match, TaskMonitor monitor) throws IOException {
        byte[] curbuf;
        int subindex;
        SequenceSearchState curstate;
        int i;
        byte[] tmp;
        int fullbuffers;
        int maxsize = this.getMaxSequenceSize() + 1;
        if (maxsize < 4096) {
            maxsize = 4096;
        }
        if (maxBytes > 0L) {
            maxBytes += (long)(this.getMaxSequenceSize() + 1);
        }
        byte[] firstbuf = new byte[maxsize];
        byte[] secondbuf = new byte[maxsize];
        int ra = in.read(firstbuf);
        if (ra == firstbuf.length) {
            ra = in.read(secondbuf);
            if (ra == secondbuf.length) {
                fullbuffers = 2;
            } else {
                if (ra < 0) {
                    ra = 0;
                }
                fullbuffers = 1;
                tmp = new byte[ra];
                for (i = 0; i < ra; ++i) {
                    tmp[i] = secondbuf[i];
                }
                secondbuf = tmp;
            }
        } else {
            if (ra < 0) {
                return;
            }
            tmp = new byte[ra];
            for (i = 0; i < ra; ++i) {
                tmp[i] = firstbuf[i];
            }
            firstbuf = tmp;
            fullbuffers = 0;
            secondbuf = new byte[]{};
        }
        int offset = 0;
        int bufreloff = 0;
        while (fullbuffers == 2) {
            curstate = this;
            subindex = bufreloff;
            curbuf = firstbuf;
            do {
                if (curstate.success != null) {
                    curstate.exportSuccess(match, offset);
                }
                if (subindex >= curbuf.length) {
                    curbuf = secondbuf;
                    subindex = 0;
                }
                curstate = curstate.trans[0xFF & curbuf[subindex]];
                ++subindex;
            } while (curstate != null);
            if (maxBytes > 0L && (long)(++offset) > maxBytes) break;
            if (++bufreloff != firstbuf.length) continue;
            byte[] tmp2 = firstbuf;
            firstbuf = secondbuf;
            secondbuf = tmp2;
            ra = in.read(secondbuf);
            if (monitor != null) {
                if (monitor.isCancelled()) {
                    return;
                }
                monitor.setProgress((long)offset);
            }
            if (ra != secondbuf.length) {
                fullbuffers = 1;
                if (ra < 0) {
                    ra = 0;
                }
                tmp2 = new byte[ra];
                for (int i2 = 0; i2 < ra; ++i2) {
                    tmp2[i2] = secondbuf[i2];
                }
                secondbuf = tmp2;
            }
            bufreloff = 0;
        }
        while (fullbuffers >= 0 && (maxBytes <= 0L || (long)offset < maxBytes)) {
            if (secondbuf.length == 0) {
                fullbuffers = 0;
            }
            curstate = this;
            subindex = bufreloff;
            curbuf = firstbuf;
            do {
                if (curstate.success != null) {
                    curstate.exportSuccess(match, offset);
                }
                if (subindex >= curbuf.length) {
                    if (curbuf == secondbuf) break;
                    curbuf = secondbuf;
                    subindex = 0;
                    if (curbuf.length == 0) break;
                }
                curstate = curstate.trans[0xFF & curbuf[subindex]];
                ++subindex;
            } while (curstate != null);
            ++offset;
            if (++bufreloff != firstbuf.length) continue;
            if (fullbuffers == 0) break;
            firstbuf = secondbuf;
            fullbuffers = 0;
            bufreloff = 0;
            secondbuf = new byte[]{};
        }
    }

    public static ArrayList<SequenceSearchState> buildTransitionLevel(ArrayList<SequenceSearchState> prev, int pos) {
        ArrayList<SequenceSearchState> res = new ArrayList<SequenceSearchState>();
        for (SequenceSearchState next : prev) {
            next.trans = new SequenceSearchState[256];
            for (int i = 0; i < 256; ++i) {
                next.buildSingleTransition(res, pos, i);
            }
        }
        if (res.isEmpty()) {
            return res;
        }
        Collections.sort(res);
        ArrayList<SequenceSearchState> finalres = new ArrayList<SequenceSearchState>();
        Iterator<SequenceSearchState> iter = res.iterator();
        SequenceSearchState curpat = iter.next();
        finalres.add(curpat);
        while (iter.hasNext()) {
            SequenceSearchState nextpat = iter.next();
            int comp = curpat.compareTo(nextpat);
            if (comp == 0) {
                curpat.merge(nextpat);
                continue;
            }
            curpat = nextpat;
            finalres.add(curpat);
        }
        return finalres;
    }

    public static SequenceSearchState buildStateMachine(ArrayList<? extends DittedBitSequence> patterns) {
        SequenceSearchState root = new SequenceSearchState(null);
        int i = 0;
        while (i < patterns.size()) {
            DittedBitSequence pat = patterns.get(i);
            pat.index = i++;
            root.addSequence(pat, 0);
        }
        root.sortSequences();
        ArrayList<SequenceSearchState> statelevel = new ArrayList<SequenceSearchState>();
        statelevel.add(root);
        int level = 0;
        do {
            statelevel = SequenceSearchState.buildTransitionLevel(statelevel, level);
            ++level;
        } while (!statelevel.isEmpty());
        return root;
    }
}

