/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CommentFieldLocation;

public class PlateFieldLocation
extends CommentFieldLocation {
    private int commentRow;

    public PlateFieldLocation(Program program, Address addr, int[] componentPath, int row, int charOffset, String[] comment, int commentRow) {
        super(program, addr, componentPath, comment, 3, row, charOffset);
        this.commentRow = commentRow;
    }

    public PlateFieldLocation() {
    }

    @Override
    public String toString() {
        return super.toString() + ", Comment Row = " + this.commentRow;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            PlateFieldLocation loc = (PlateFieldLocation)obj;
            return this.commentRow == loc.commentRow;
        }
        return false;
    }

    public int getCommentRow() {
        return this.commentRow;
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.commentRow = obj.getInt("_COMMENT_ROW", 0);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putInt("_COMMENT_ROW", this.commentRow);
    }
}

