/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Data;
import ghidra.program.util.AddressCorrelation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class LinearDataAddressCorrelation
implements AddressCorrelation {
    private final Data sourceData;
    private final Data destinationData;

    public LinearDataAddressCorrelation(Data sourceData, Data destinationData) {
        this.sourceData = sourceData;
        this.destinationData = destinationData;
    }

    @Override
    public AddressRange getCorrelatedDestinationRange(Address sourceAddress, TaskMonitor monitor) throws CancelledException {
        long offset = sourceAddress.getOffset();
        long base = this.sourceData.getAddress().getOffset();
        long delta = offset - base;
        Address address = this.destinationData.getAddress().add(delta);
        return new AddressRangeImpl(address, address);
    }

    @Override
    public String getName() {
        return "LinearDataAddressCorrelation";
    }
}

