/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class VarnodeAST
extends Varnode {
    private boolean bInput = false;
    private boolean bAddrTied = false;
    private boolean bPersistant = false;
    private boolean bUnaffected = false;
    private boolean bFree = true;
    private int uniqId;
    private short mergegroup;
    private HighVariable high;
    private PcodeOp def;
    private LinkedList<PcodeOp> descend;

    public VarnodeAST(Address a, int sz, int id) {
        super(a, sz);
        this.uniqId = id;
        this.def = null;
        this.mergegroup = 0;
        this.descend = new LinkedList();
    }

    @Override
    public boolean isFree() {
        return this.bFree;
    }

    @Override
    public boolean isInput() {
        return this.bInput;
    }

    @Override
    public boolean isPersistant() {
        return this.bPersistant;
    }

    @Override
    public boolean isAddrTied() {
        return this.bAddrTied;
    }

    @Override
    public boolean isUnaffected() {
        return this.bUnaffected;
    }

    @Override
    public PcodeOp getDef() {
        return this.def;
    }

    @Override
    public Iterator<PcodeOp> getDescendants() {
        return this.descend.iterator();
    }

    @Override
    public Address getPCAddress() {
        if (this.bInput) {
            return Address.NO_ADDRESS;
        }
        if (this.def != null) {
            return this.def.getSeqnum().getTarget();
        }
        if (this.descend.size() == 1) {
            return this.descend.get(0).getSeqnum().getTarget();
        }
        return Address.NO_ADDRESS;
    }

    @Override
    public HighVariable getHigh() {
        return this.high;
    }

    public int getUniqueId() {
        return this.uniqId;
    }

    @Override
    public short getMergeGroup() {
        return this.mergegroup;
    }

    public void setAddrtied(boolean val) {
        this.bAddrTied = val;
    }

    public void setInput(boolean val) {
        this.bInput = val;
        this.bFree = false;
        this.def = null;
    }

    public void setPersistant(boolean val) {
        this.bPersistant = val;
    }

    public void setUnaffected(boolean val) {
        this.bUnaffected = val;
    }

    public void setFree(boolean val) {
        this.bFree = val;
    }

    public void setDef(PcodeOp op) {
        this.def = op;
        if (op != null) {
            this.bFree = false;
            this.bInput = false;
        }
    }

    public void setMergeGroup(short val) {
        this.mergegroup = val;
    }

    public void setHigh(HighVariable hi) {
        this.high = hi;
    }

    public void addDescendant(PcodeOp op) {
        this.descend.add(op);
    }

    public void removeDescendant(PcodeOp op) {
        ListIterator iter = this.descend.listIterator();
        while (iter.hasNext()) {
            if (op != iter.next()) continue;
            iter.remove();
        }
    }

    public void descendReplace(VarnodeAST vn) {
        ListIterator iter = vn.descend.listIterator();
        block0: while (iter.hasNext()) {
            PcodeOp op = (PcodeOp)iter.next();
            if (op.getOutput() == this) continue;
            int num = op.getNumInputs();
            for (int i = 0; i < num; ++i) {
                if (op.getInput(i) != vn) continue;
                vn.removeDescendant(op);
                op.setInput(null, i);
                this.addDescendant(op);
                op.setInput(this, i);
                continue block0;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarnodeAST)) {
            return false;
        }
        VarnodeAST vn = (VarnodeAST)o;
        if (this.getOffset() != vn.getOffset() || this.getSize() != vn.getSize() || this.getSpace() != vn.getSpace()) {
            return false;
        }
        if (this.isFree()) {
            if (vn.isFree()) {
                return this.uniqId == vn.uniqId;
            }
            return false;
        }
        if (vn.isFree()) {
            return false;
        }
        if (this.isInput() != vn.isInput()) {
            return false;
        }
        if (this.def != null) {
            PcodeOp vnDef = vn.getDef();
            if (vnDef == null) {
                return false;
            }
            return this.def.getSeqnum().equals(vnDef.getSeqnum());
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.uniqId;
    }
}

