/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VariableUtilities {
    private static int PARAMETER_PRECEDENCE = 10;
    private static int UNIQUE_PRECEDENCE = 16;
    private static int MEMORY_PRECEDENCE = 15;
    private static int STACK_PRECEDENCE = 14;
    private static int REGISTER_PRECEDENCE = 13;
    private static int COMPOUND_PRECEDENCE = 11;

    private VariableUtilities() {
    }

    public static int getPrecedence(Variable var) {
        int precedence = var.isMemoryVariable() ? MEMORY_PRECEDENCE : (var.isRegisterVariable() ? REGISTER_PRECEDENCE : (var.isStackVariable() ? STACK_PRECEDENCE : (var.isUniqueVariable() ? UNIQUE_PRECEDENCE : (var.isCompoundVariable() ? COMPOUND_PRECEDENCE : 0))));
        if (var instanceof Parameter) {
            precedence -= PARAMETER_PRECEDENCE;
        }
        return precedence;
    }

    public static boolean storageMatches(List<Variable> vars, List<Variable> otherVars) {
        if (otherVars.size() != vars.size()) {
            return false;
        }
        for (int i = 0; i < otherVars.size(); ++i) {
            if (otherVars.get(i).getVariableStorage().equals(vars.get(i).getVariableStorage())) continue;
            return false;
        }
        return true;
    }

    public static boolean storageMatches(List<? extends Variable> vars, Variable ... otherVars) {
        if (otherVars.length != vars.size()) {
            return false;
        }
        for (int i = 0; i < otherVars.length; ++i) {
            VariableStorage storage = vars.get(i).getVariableStorage();
            VariableStorage otherStorage = otherVars[i].getVariableStorage();
            if (Arrays.equals(storage.getVarnodes(), otherStorage.getVarnodes())) continue;
            return false;
        }
        return true;
    }

    public static int compare(Variable v1, Variable v2) {
        if (v1 instanceof Parameter && v2 instanceof Parameter) {
            return ((Parameter)v1).getOrdinal() - ((Parameter)v2).getOrdinal();
        }
        int diff = VariableUtilities.getPrecedence(v1) - VariableUtilities.getPrecedence(v2);
        if (diff != 0) {
            return diff;
        }
        VariableStorage otherStorage = v2.getVariableStorage();
        VariableStorage variableStorage = v1.getVariableStorage();
        if (v1.isStackVariable() && v2.isStackVariable() && (diff = v2.getStackOffset() - v1.getStackOffset()) != 0) {
            return diff;
        }
        diff = v1.getFirstUseOffset() - v2.getFirstUseOffset();
        if (diff != 0) {
            if (v1.getFirstUseOffset() == 0) {
                return -1;
            }
            if (v2.getFirstUseOffset() == 0) {
                return 1;
            }
            return diff;
        }
        return variableStorage.compareTo(otherStorage);
    }

    public static DataType getAutoDataType(Function function, DataType returnDataType, VariableStorage storage) {
        AutoParameterType autoParameterType = storage.getAutoParameterType();
        if (autoParameterType == AutoParameterType.THIS) {
            DataType classStruct = VariableUtilities.findOrCreateClassStruct(function);
            if (classStruct == null) {
                classStruct = DataType.VOID;
            }
            return VariableUtilities.getPointer(function.getProgram(), classStruct, storage.size());
        }
        if (autoParameterType == AutoParameterType.RETURN_STORAGE_PTR) {
            return VariableUtilities.getPointer(function.getProgram(), returnDataType, storage.size());
        }
        return Undefined.getUndefinedDataType(storage.size());
    }

    private static Pointer getPointer(Program program, DataType baseType, int ptrSize) {
        DataTypeManager dtMgr = program.getDataTypeManager();
        if (program.getDefaultPointerSize() == ptrSize) {
            return dtMgr.getPointer(baseType);
        }
        return dtMgr.getPointer(baseType, ptrSize);
    }

    public static void checkStorage(VariableStorage storage, DataType dataType, boolean allowSizeMismatch) throws InvalidInputException {
        VariableUtilities.checkStorage(null, storage, dataType, allowSizeMismatch);
    }

    public static VariableStorage checkStorage(Function function, VariableStorage storage, DataType dataType, boolean allowSizeMismatch) throws InvalidInputException {
        if (!storage.isValid()) {
            return storage;
        }
        DataType baseType = dataType;
        if (baseType instanceof TypeDef) {
            baseType = ((TypeDef)baseType).getBaseDataType();
        }
        int storageSize = storage.size();
        int dtLen = dataType.getLength();
        if (baseType instanceof VoidDataType) {
            storage = VariableStorage.VOID_STORAGE;
        } else {
            if (storage.isUniqueStorage() || storage.isConstantStorage()) {
                throw new InvalidInputException("Invalid storage address specified: " + storage);
            }
            if (dtLen == 0 && baseType instanceof Structure) {
                storage = VariableStorage.UNASSIGNED_STORAGE;
            } else if (!allowSizeMismatch && storageSize != dtLen) {
                if (dataType instanceof AbstractFloatDataType) {
                    return storage;
                }
                if (function != null) {
                    return VariableUtilities.resizeStorage(storage, dataType, true, function);
                }
                if (dtLen < storageSize && storage.isRegisterStorage()) {
                    return new VariableStorage(storage.getProgram(), VariableUtilities.shrinkRegister(storage.getRegister(), storageSize - dtLen));
                }
                throw new InvalidInputException("Storage size does not match data type size: " + dataType.getLength());
            }
        }
        return storage;
    }

    public static DataType checkDataType(DataType dataType, boolean voidOK, int defaultSize, Program program) throws InvalidInputException {
        if (dataType instanceof BitFieldDataType) {
            throw new InvalidInputException("Bitfields not supported for variable");
        }
        if (dataType == null) {
            if (voidOK) {
                return VoidDataType.dataType;
            }
            dataType = Undefined.getUndefinedDataType(defaultSize);
        } else if (dataType.isDynamicallySized()) {
            dataType = dataType.clone(program.getDataTypeManager());
        } else if (dataType instanceof FunctionDefinition || dataType instanceof TypeDef && ((TypeDef)dataType).getBaseDataType() instanceof FunctionDefinition) {
            dataType = new PointerDataType(dataType, program.getDataTypeManager());
        }
        if (dataType.getLength() <= 0) {
            if (dataType instanceof Dynamic || dataType instanceof FactoryDataType) {
                throw new InvalidInputException("Dynamic or Factory data-type not allowed: " + dataType.getName());
            }
            DataType baseType = dataType;
            if (baseType instanceof TypeDef) {
                baseType = ((TypeDef)baseType).getBaseDataType();
            }
            if (!(baseType instanceof Structure || baseType instanceof VoidDataType && voidOK)) {
                throw new InvalidInputException("Expected fixed-length data type with positive size");
            }
        }
        return dataType;
    }

    public static VariableStorage resizeStorage(VariableStorage curStorage, DataType dataType, boolean alignStack, Function function) throws InvalidInputException {
        if (!curStorage.isValid()) {
            return curStorage;
        }
        int newSize = dataType.getLength();
        int curSize = curStorage.size();
        if (curSize == newSize) {
            return curStorage;
        }
        if (curSize == 0 || curStorage.isUniqueStorage() || curStorage.isHashStorage()) {
            throw new InvalidInputException("Storage can't be resized: " + curStorage.toString());
        }
        if (dataType instanceof TypeDef) {
            dataType = ((TypeDef)dataType).getBaseDataType();
        }
        if (dataType instanceof AbstractFloatDataType) {
            return curStorage;
        }
        if (newSize > curSize) {
            return VariableUtilities.expandStorage(curStorage, newSize, dataType, alignStack, function);
        }
        return VariableUtilities.shrinkStorage(curStorage, newSize, dataType, alignStack, function);
    }

    private static VariableStorage shrinkStorage(VariableStorage curStorage, int newSize, DataType dataType, boolean alignStack, Function function) throws InvalidInputException {
        Program program = function.getProgram();
        ArrayList<Varnode> newList = new ArrayList<Varnode>();
        int size = 0;
        for (Varnode vn : curStorage.getVarnodes()) {
            if ((size += vn.getSize()) >= newSize) {
                newList.add(VariableUtilities.shrinkVarnode(vn, size - newSize, curStorage, newSize, dataType, alignStack, function));
                break;
            }
            newList.add(vn);
        }
        return new VariableStorage(program, newList);
    }

    private static VariableStorage expandStorage(VariableStorage curStorage, int newSize, DataType dataType, boolean alignStack, Function function) throws InvalidInputException {
        Program program = function.getProgram();
        Varnode[] varnodes = curStorage.getVarnodes();
        int lastIndex = varnodes.length - 1;
        varnodes[lastIndex] = VariableUtilities.expandVarnode(varnodes[lastIndex], newSize - curStorage.size(), curStorage, newSize, dataType, alignStack, function);
        return new VariableStorage(program, varnodes);
    }

    private static Varnode shrinkVarnode(Varnode varnode, int sizeReduction, VariableStorage curStorage, int newSize, DataType dataType, boolean alignStack, Function function) throws InvalidInputException {
        boolean complexDt;
        Address addr = varnode.getAddress();
        if (addr.isStackAddress()) {
            return VariableUtilities.resizeStackVarnode(varnode, varnode.getSize() - sizeReduction, curStorage, newSize, dataType, alignStack, function);
        }
        boolean isRegister = function.getProgram().getRegister(varnode) != null;
        boolean bigEndian = function.getProgram().getMemory().isBigEndian();
        boolean bl = complexDt = dataType instanceof Composite || dataType instanceof Array;
        if (bigEndian && (isRegister || !complexDt)) {
            return new Varnode(varnode.getAddress().add(sizeReduction), varnode.getSize() - sizeReduction);
        }
        return new Varnode(varnode.getAddress(), varnode.getSize() - sizeReduction);
    }

    private static Varnode shrinkRegister(Register reg, int sizeReduction) {
        boolean bigEndian = reg.isBigEndian();
        if (bigEndian) {
            return new Varnode(reg.getAddress().add(sizeReduction), reg.getMinimumByteSize() - sizeReduction);
        }
        return new Varnode(reg.getAddress(), reg.getMinimumByteSize() - sizeReduction);
    }

    private static Varnode expandVarnode(Varnode varnode, int sizeIncrease, VariableStorage curStorage, int newSize, DataType dataType, boolean alignStack, Function function) throws InvalidInputException {
        boolean complexDt;
        Address addr = varnode.getAddress();
        if (addr.isStackAddress()) {
            return VariableUtilities.resizeStackVarnode(varnode, varnode.getSize() + sizeIncrease, curStorage, newSize, dataType, alignStack, function);
        }
        int size = varnode.getSize() + sizeIncrease;
        boolean bigEndian = function.getProgram().getMemory().isBigEndian();
        Register reg = function.getProgram().getRegister(varnode);
        Address vnAddr = varnode.getAddress();
        if (reg != null) {
            Register newReg = reg;
            while (newReg.getMinimumByteSize() < size) {
                if ((newReg = newReg.getParentRegister()) != null) continue;
                throw new InvalidInputException("Storage can't be expanded to " + newSize + " bytes: " + curStorage.toString());
            }
            vnAddr = newReg.getAddress();
            if (bigEndian) {
                vnAddr = vnAddr.add(newReg.getMinimumByteSize() - size);
                return new Varnode(vnAddr, size);
            }
        }
        boolean bl = complexDt = dataType instanceof Composite || dataType instanceof Array;
        if (bigEndian && !complexDt) {
            return new Varnode(vnAddr.subtract(sizeIncrease), size);
        }
        return new Varnode(vnAddr, size);
    }

    private static Varnode resizeStackVarnode(Varnode varnode, int newVarnodeSize, VariableStorage curStorage, int newSize, DataType dataType, boolean align, Function function) throws InvalidInputException {
        int stackOffset;
        boolean complexDt = dataType instanceof Composite || dataType instanceof Array;
        StackAttributes stackAttributes = VariableUtilities.getStackAttributes(function);
        Address curAddr = varnode.getAddress();
        int newStackOffset = stackOffset = (int)curAddr.getOffset();
        if (stackAttributes.rightJustify && align) {
            int cellExcess;
            int newAlign;
            int stackAlign = stackAttributes.stackAlign;
            if ((stackOffset + varnode.getSize() - stackAttributes.bias) % stackAlign != 0) {
                stackAlign = 1;
            }
            if ((newAlign = (newStackOffset - stackAttributes.bias) % stackAlign) < 0) {
                newAlign += stackAlign;
            }
            newStackOffset -= newAlign;
            if (!complexDt && (cellExcess = newVarnodeSize % stackAlign) != 0) {
                newStackOffset += stackAlign - cellExcess;
            }
        }
        int newEndStackOffset = newStackOffset + newVarnodeSize - 1;
        if (newStackOffset < 0 && newEndStackOffset >= 0) {
            throw new InvalidInputException("Data type does not fit within variable stack constraints");
        }
        return new Varnode(curAddr.getNewAddress(newStackOffset), newVarnodeSize);
    }

    private static StackAttributes getStackAttributes(Function function) {
        int stackAlign;
        CompilerSpec compilerSpec = function.getProgram().getCompilerSpec();
        boolean rightJustify = compilerSpec.isStackRightJustified();
        PrototypeModel callingConvention = function.getCallingConvention();
        if (callingConvention == null) {
            callingConvention = compilerSpec.getDefaultCallingConvention();
        }
        if ((stackAlign = callingConvention.getStackParameterAlignment()) < 0) {
            stackAlign = 1;
        }
        int bias = 0;
        Long stackBase = callingConvention.getStackParameterOffset();
        if (stackBase != null && (bias = (int)(stackBase % (long)stackAlign)) < 0) {
            bias += stackAlign;
        }
        return new StackAttributes(stackAlign, bias, rightJustify);
    }

    public static void checkVariableConflict(Function function, Variable var, VariableStorage newStorage, boolean deleteConflictingVariables) throws VariableSizeException {
        if (!newStorage.isValid()) {
            return;
        }
        ArrayList<Variable> conflicts = null;
        for (Variable otherVar : function.getAllVariables()) {
            if (otherVar.equals(var) || var != null && otherVar.getFirstUseOffset() != var.getFirstUseOffset() || !otherVar.getVariableStorage().intersects(newStorage)) continue;
            if (deleteConflictingVariables) {
                function.removeVariable(otherVar);
                continue;
            }
            if (conflicts == null) {
                conflicts = new ArrayList<Variable>();
            }
            conflicts.add(otherVar);
        }
        if (conflicts != null) {
            VariableUtilities.generateConflictException(newStorage, conflicts, 4);
        }
    }

    public static void checkVariableConflict(List<? extends Variable> existingVariables, Variable var, VariableStorage newStorage, VariableConflictHandler conflictHandler) throws VariableSizeException {
        if (!newStorage.isValid()) {
            return;
        }
        ArrayList<Variable> conflicts = null;
        for (Variable variable : existingVariables) {
            if (variable == null || variable.equals(var) || var != null && variable.getFirstUseOffset() != var.getFirstUseOffset() || !variable.getVariableStorage().intersects(newStorage)) continue;
            if (conflicts == null) {
                conflicts = new ArrayList<Variable>();
            }
            conflicts.add(variable);
        }
        if (!(conflicts == null || conflictHandler != null && conflictHandler.resolveConflicts(conflicts))) {
            VariableUtilities.generateConflictException(newStorage, conflicts, 4);
        }
    }

    private static void generateConflictException(VariableStorage newStorage, List<Variable> conflicts, int maxConflictVarDetails) throws VariableSizeException {
        maxConflictVarDetails = Math.min(conflicts.size(), maxConflictVarDetails);
        StringBuffer msg = new StringBuffer();
        msg.append("Variable storage conflict between " + newStorage + " and: ");
        for (int i = 0; i < maxConflictVarDetails; ++i) {
            if (i != 0) {
                msg.append(", ");
            }
            msg.append(conflicts.get(i).getVariableStorage().toString());
        }
        if (maxConflictVarDetails < conflicts.size()) {
            msg.append(" ... {");
            msg.append(Integer.toString(conflicts.size() - maxConflictVarDetails));
            msg.append(" more}");
        }
        throw new VariableSizeException(msg.toString(), true);
    }

    public static Integer getBaseStackParamOffset(Function function) {
        PrototypeModel convention = function.getCallingConvention();
        if (convention == null) {
            convention = function.getProgram().getCompilerSpec().getDefaultCallingConvention();
        }
        Integer baseOffset = null;
        if (convention != null) {
            Long val = convention.getStackParameterOffset();
            baseOffset = val == null ? Integer.valueOf(convention.getStackshift()) : Integer.valueOf(val.intValue());
        }
        return baseOffset;
    }

    @Deprecated
    public static ParameterImpl getThisParameter(Function function, PrototypeModel convention) {
        if (convention != null && convention.getGenericCallingConvention() == GenericCallingConvention.thiscall) {
            DataType dt = VariableUtilities.findOrCreateClassStruct(function);
            if (dt == null) {
                dt = DataType.VOID;
            }
            dt = new PointerDataType(dt);
            DataType[] arr = new DataType[]{DataType.VOID, dt};
            VariableStorage thisStorage = convention.getStorageLocations(function.getProgram(), arr, true)[1];
            try {
                return new ParameterImpl("this", 0, dt, thisStorage, false, function.getProgram(), SourceType.ANALYSIS);
            }
            catch (InvalidInputException e) {
                Msg.error(VariableUtilities.class, (Object)("Error while generating 'this' parameter for function at " + function.getEntryPoint() + ": " + e.getMessage()));
            }
        }
        return null;
    }

    private static Structure createPlaceholderClassStruct(GhidraClass classNamespace, DataTypeManager dataTypeManager) {
        Namespace classParentNamespace = classNamespace.getParentNamespace();
        CategoryPath category = DataTypeUtilities.getDataTypeCategoryPath(CategoryPath.ROOT, classParentNamespace);
        StructureDataType structDT = new StructureDataType(category, classNamespace.getName(), 0, dataTypeManager);
        structDT.setDescription("PlaceHolder Class Structure");
        return structDT;
    }

    public static Structure findOrCreateClassStruct(GhidraClass classNamespace, DataTypeManager dataTypeManager) {
        Structure struct = VariableUtilities.findExistingClassStruct(classNamespace, dataTypeManager);
        if (struct == null) {
            struct = VariableUtilities.createPlaceholderClassStruct(classNamespace, dataTypeManager);
        }
        return struct;
    }

    public static Structure findOrCreateClassStruct(Function function) {
        Namespace namespace = function.getParentNamespace();
        if (!(namespace instanceof GhidraClass)) {
            return null;
        }
        return VariableUtilities.findOrCreateClassStruct((GhidraClass)namespace, function.getProgram().getDataTypeManager());
    }

    public static Structure findExistingClassStruct(GhidraClass classNamespace, DataTypeManager dataTypeManager) {
        return (Structure)DataTypeUtilities.findDataType(dataTypeManager, classNamespace.getParentNamespace(), classNamespace.getName(), Structure.class);
    }

    public static Structure findExistingClassStruct(Function func) {
        Namespace namespace = func.getParentNamespace();
        if (!(namespace instanceof GhidraClass)) {
            return null;
        }
        return VariableUtilities.findExistingClassStruct((GhidraClass)namespace, func.getProgram().getDataTypeManager());
    }

    public static boolean equivalentVariableArrays(Variable[] vars1, Variable[] vars2) {
        if (vars1 == vars2) {
            return true;
        }
        if (vars1 == null || vars2 == null) {
            return false;
        }
        int length = vars1.length;
        if (vars2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (vars1[i] != null ? VariableUtilities.equivalentVariables(vars1[i], vars2[i]) : vars2[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean equivalentVariables(Variable var1, Variable var2) {
        String comment1 = var1.getComment();
        String comment2 = var2.getComment();
        return var1.equals(var2) && var1.getName().equals(var2.getName()) && var1.getDataType().isEquivalent(var2.getDataType()) && (comment1 == null ? comment2 == null : comment1.equals(comment2));
    }

    public static interface VariableConflictHandler {
        public boolean resolveConflicts(List<Variable> var1);
    }

    private static class StackAttributes {
        final int stackAlign;
        final int bias;
        final boolean rightJustify;

        public StackAttributes(int stackAlign, int bias, boolean rightJustify) {
            this.stackAlign = stackAlign;
            this.bias = bias;
            this.rightJustify = rightJustify;
        }
    }
}

