/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SimpleBlockIterator
implements CodeBlockIterator {
    private Listing listing = null;
    private CodeBlock nextBlock = null;
    private Address nextAddr = null;
    private AddressSetView addrSet = null;
    private AddressRangeIterator rangeIter = null;
    private SimpleBlockModel model = null;
    private TaskMonitor monitor;

    public SimpleBlockIterator(SimpleBlockModel model, TaskMonitor monitor) throws CancelledException {
        this(model, model.getProgram().getMemory(), monitor);
    }

    public SimpleBlockIterator(SimpleBlockModel model, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        this.model = model;
        this.monitor = monitor != null ? monitor : TaskMonitor.DUMMY;
        this.listing = model.getProgram().getListing();
        this.addrSet = set;
        this.rangeIter = set.getAddressRanges();
        this.nextAddr = set.getMinAddress();
        this.nextBlock = this.nextAddr == null ? null : model.getFirstCodeBlockContaining(this.nextAddr, monitor);
        if (this.nextBlock != null) {
            this.nextAddr = this.nextBlock.getMaxAddress();
            CodeUnit codeUnit = this.listing.getCodeUnitAt(this.nextBlock.getMinAddress());
            if (codeUnit instanceof Data) {
                this.nextBlock = null;
            }
        }
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.nextBlock != null) {
            return true;
        }
        this.getNextInSet();
        return this.nextBlock != null;
    }

    @Override
    public CodeBlock next() throws CancelledException {
        if (this.nextBlock == null) {
            this.hasNext();
        }
        CodeBlock retBlock = this.nextBlock;
        this.nextBlock = null;
        return retBlock;
    }

    private void getNextInSet() throws CancelledException {
        Address addr = this.getNextAddress(this.nextAddr);
        if (addr != null && this.addrSet.contains(addr)) {
            this.nextBlock = this.model.getCodeBlockAt(addr, this.monitor);
            if (this.nextBlock != null) {
                this.nextAddr = this.nextBlock.getMaxAddress();
                return;
            }
        }
        while (this.rangeIter.hasNext()) {
            AddressRange range = (AddressRange)this.rangeIter.next();
            if (this.nextAddr.compareTo(range.getMinAddress()) >= 0) continue;
            this.nextBlock = this.getFirstInRange(range);
            if (this.nextBlock == null) continue;
            this.nextAddr = this.nextBlock.getMaxAddress();
            return;
        }
        this.nextBlock = null;
    }

    private Address getNextAddress(Address addr) {
        Instruction instr = this.listing.getInstructionAfter(addr);
        Address instrAddr = instr != null ? instr.getMinAddress() : null;
        return instrAddr;
    }

    private CodeBlock getFirstInRange(AddressRange range) throws CancelledException {
        Address addr = range.getMinAddress();
        if (addr == null) {
            return null;
        }
        do {
            CodeBlock block;
            if ((block = this.model.getFirstCodeBlockContaining(addr, this.monitor)) != null) {
                CodeUnit codeUnit = this.listing.getCodeUnitAt(block.getMinAddress());
                if (codeUnit instanceof Instruction) {
                    return block;
                }
                addr = block.getMaxAddress();
            }
            addr = this.getNextAddress(addr);
        } while (!this.monitor.isCancelled() && addr != null && range.contains(addr));
        return null;
    }
}

