/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.function.FunctionTagManagerDB;
import ghidra.program.model.listing.FunctionTag;
import java.io.IOException;

public class FunctionTagDB
extends DatabaseObject
implements FunctionTag {
    private FunctionTagManagerDB mgr;
    private Record record;

    public FunctionTagDB(FunctionTagManagerDB mgr, DBObjectCache<FunctionTagDB> cache, Record record) {
        super(cache, record.getKey());
        this.mgr = mgr;
        this.record = record;
    }

    @Override
    public long getId() {
        return this.key;
    }

    @Override
    public void setComment(String comment) {
        this.mgr.lock.acquire();
        try {
            this.checkDeleted();
            if (comment == null) {
                comment = "";
            }
            if (!comment.equals(this.record.getString(1))) {
                this.record.setString(1, comment);
                this.mgr.updateFunctionTag(this);
            }
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public void setName(String name) {
        this.mgr.lock.acquire();
        try {
            this.checkDeleted();
            if (name == null) {
                name = "";
            }
            if (!name.equals(this.record.getString(0))) {
                this.record.setString(0, name);
                this.mgr.updateFunctionTag(this);
            }
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public String getComment() {
        this.mgr.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(1);
            return string;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public String getName() {
        this.mgr.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(0);
            return string;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    Record getRecord() {
        return this.record;
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(Record rec) {
        if (rec == null) {
            try {
                rec = this.mgr.getFunctionTagAdapter().getRecord(this.key);
            }
            catch (IOException e) {
                this.mgr.dbError(e);
            }
        }
        if (rec == null) {
            return false;
        }
        this.record = rec;
        return true;
    }

    public int hashCode() {
        return (int)this.key;
    }

    @Override
    public int compareTo(FunctionTag otherTag) {
        int rc = this.getName().compareToIgnoreCase(otherTag.getName());
        if (rc != 0) {
            return rc;
        }
        return this.getComment().compareToIgnoreCase(otherTag.getComment());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FunctionTag)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FunctionTag tag = (FunctionTag)obj;
        if (!this.getName().equals(tag.getName())) {
            return false;
        }
        return this.getComment().equals(tag.getComment());
    }

    @Override
    public void delete() {
        this.mgr.lock.acquire();
        try {
            if (this.checkIsValid()) {
                this.mgr.doDeleteTag(this);
            }
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        finally {
            this.mgr.lock.release();
        }
    }
}

