/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ConstructState;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class OperandValue
extends PatternValue {
    private int index;
    private Constructor ct;

    public OperandValue(Location location) {
        super(location);
    }

    public OperandValue(Location location, int ind, Constructor c) {
        super(location);
        this.index = ind;
        this.ct = c;
    }

    public void changeIndex(int newind) {
        this.index = newind;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return (TokenPattern)ops.get(this.index);
    }

    @Override
    public TokenPattern genPattern(long val) {
        throw new SleighError("Operand used in pattern expression", this.ct.location);
    }

    @Override
    public long minValue() {
        throw new SleighError("Operand used in pattern expression", this.ct.location);
    }

    @Override
    public long maxValue() {
        throw new SleighError("Operand used in pattern expression", this.ct.location);
    }

    @Override
    public long getValue(ParserWalker pos) {
        OperandSymbol sym = this.ct.getOperand(this.index);
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp == null) {
            TripleSymbol defsym = sym.getDefiningSymbol();
            if (defsym != null) {
                patexp = defsym.getPatternExpression();
            }
            if (patexp == null) {
                return 0L;
            }
        }
        ConstructState tempstate = new ConstructState();
        ParserWalker newwalker = new ParserWalker(pos.getParserContext());
        newwalker.setOutOfBandState(this.ct, this.index, tempstate, pos);
        long res = patexp.getValue(newwalker);
        return res;
    }

    @Override
    public long getSubValue(VectorSTL<Long> replace, MutableInt listpos) {
        OperandSymbol sym = this.ct.getOperand(this.index);
        return sym.getDefiningExpression().getSubValue(replace, listpos);
    }

    public boolean isConstructorRelative() {
        OperandSymbol sym = this.ct.getOperand(this.index);
        return sym.getOffsetBase() == -1;
    }

    public String getName() {
        OperandSymbol sym = this.ct.getOperand(this.index);
        return sym.getName();
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<operand_exp");
        s.append(" index=\"");
        s.print(this.index);
        s.append("\"");
        s.append(" table=\"0x");
        int id = this.ct == null ? 0 : this.ct.getParent().getId();
        s.append(Long.toHexString(id));
        s.append("\"");
        s.append(" ct=\"0x");
        long ctid = this.ct == null ? 0L : this.ct.getId();
        s.append(Long.toHexString(ctid));
        s.append("\"/>\n");
    }

    @Override
    public void restoreXml(Element el, Translate trans) {
        this.index = XmlUtils.decodeUnknownInt(el.getAttributeValue("index"));
        long tabid = XmlUtils.decodeUnknownLong(el.getAttributeValue("table"));
        long ctid = XmlUtils.decodeUnknownLong(el.getAttributeValue("ct"));
        SleighBase sleigh = (SleighBase)trans;
        SubtableSymbol tab = (SubtableSymbol)sleigh.findSymbol((int)tabid);
        this.ct = tab.getConstructor((int)ctid);
    }
}

