/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeSlowLoadingNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class GTreeLoadChildrenTask
extends GTreeTask {
    private final GTreeSlowLoadingNode node;

    public GTreeLoadChildrenTask(GTree tree, GTreeSlowLoadingNode node) {
        super(tree);
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        long progressValue = monitor.getProgress();
        long maxValue = monitor.getMaximum();
        monitor.setMessage("Loading children");
        try {
            this.node.setChildren(this.node.generateChildren(monitor));
        }
        catch (CancelledException e) {
            if (!this.tree.isDisposed()) {
                this.runOnSwingThread(new Runnable(){

                    @Override
                    public void run() {
                        GTreeLoadChildrenTask.this.tree.collapseAll(GTreeLoadChildrenTask.this.tree.getRootNode());
                    }
                });
            }
            this.node.removeAll();
        }
        finally {
            monitor.initialize(maxValue);
            monitor.setProgress(progressValue);
        }
    }
}

