/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.TextFilter;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class AbstractPatternTextFilter
implements TextFilter {
    protected final String filterText;
    protected Pattern filterPattern;

    protected AbstractPatternTextFilter(String filterText) {
        this.filterText = filterText;
    }

    protected abstract Pattern createPattern();

    public abstract boolean matches(String var1, Pattern var2);

    @Override
    public String getFilterText() {
        return this.filterText;
    }

    @Override
    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        Pattern pattern = this.getFilterPattern();
        if (pattern == null) {
            return false;
        }
        return this.matches(text, pattern);
    }

    private Pattern getFilterPattern() {
        if (this.filterPattern == null) {
            this.filterPattern = this.createPattern();
        }
        return this.filterPattern;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPatternTextFilter other = (AbstractPatternTextFilter)obj;
        if (!this.patternsEqual(this.createPattern(), other.createPattern())) {
            return false;
        }
        return Objects.equals(this.filterText, other.filterText);
    }

    private boolean patternsEqual(Pattern p1, Pattern p2) {
        int f2;
        String otherPattern;
        String myPattern = this.getPatternString(p1);
        if (!myPattern.equals(otherPattern = this.getPatternString(p2))) {
            return false;
        }
        int f1 = this.getPatternFlags(p1);
        return f1 == (f2 = this.getPatternFlags(p2));
    }

    private String getPatternString(Pattern p) {
        return p == null ? "" : p.pattern();
    }

    private int getPatternFlags(Pattern p) {
        return p == null ? -1 : p.flags();
    }

    public String toString() {
        return "{\n\tfilter: " + this.filterText + ",\n\tpattern: " + this.getFilterPattern() + ",\n}";
    }
}

