/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import ghidra.framework.main.datatable.ProjectDataActionContext;
import ghidra.framework.main.datatable.ProjectDataContextAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class ProjectDataNewFolderAction
extends ProjectDataContextAction {
    private static Icon icon = ResourceManager.loadImage((String)"images/folder_add.png");

    public ProjectDataNewFolderAction(String owner, String group) {
        super("New Folder", owner);
        this.setPopupMenuData(new MenuData(new String[]{"New Folder"}, icon, group));
        this.markHelpUnnecessary();
    }

    @Override
    protected boolean supportsTransientProjectData() {
        return true;
    }

    @Override
    protected void actionPerformed(ProjectDataActionContext context) {
        this.createNewFolder(context);
    }

    @Override
    public boolean isAddToPopup(ProjectDataActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof GTreeNode)) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        return context.hasExactlyOneFileOrFolder();
    }

    private void createNewFolder(ProjectDataActionContext context) {
        DomainFolder folder = this.getFolder(context);
        String name = this.getNewFolderName(folder);
        try {
            DomainFolder newFolder = folder.createFolder(name);
            DataTree tree = (DataTree)((Object)context.getComponent());
            SwingUtilities.invokeLater(() -> {
                GTreeNode node = this.findNodeForFolder(tree, newFolder);
                if (node != null) {
                    tree.setEditable(true);
                    tree.startEditing(node.getParent(), node.getName());
                }
            });
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), (Component)context.getComponent(), (String)"Create Folder Failed", (Object)e.getMessage());
        }
    }

    private static final void getFolderPath(DomainFolder folder, List<String> folderPathList) {
        if (folder.getParent() != null) {
            ProjectDataNewFolderAction.getFolderPath(folder.getParent(), folderPathList);
            folderPathList.add(folder.getName());
        }
    }

    private GTreeNode findNodeForFolder(DataTree tree, DomainFolder newFolder) {
        ArrayList<String> folderPathList = new ArrayList<String>();
        ProjectDataNewFolderAction.getFolderPath(newFolder, folderPathList);
        GTreeRootNode node = tree.getRootNode();
        for (int i = 0; node != null && i < folderPathList.size(); node = node.getChild((String)folderPathList.get(i)), ++i) {
        }
        return node;
    }

    private String getNewFolderName(DomainFolder parent) {
        String baseName = "NewFolder";
        Object name = baseName;
        int suffix = 1;
        while (parent.getFolder((String)name) != null) {
            name = baseName + ++suffix;
        }
        return name;
    }

    private DomainFolder getFolder(ProjectDataActionContext context) {
        if (context.getFolderCount() > 0) {
            return context.getSelectedFolders().get(0);
        }
        DomainFile file = context.getSelectedFiles().get(0);
        return file.getParent();
    }
}

