/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph;

import ghidra.app.plugin.core.functiongraph.graph.FGComponent;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertexTooltipProvider;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.MutableGDirectedGraphWrapper;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.FGViewUpdater;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.edge.PathHighlightListener;
import ghidra.graph.viewer.edge.VisualGraphPathHighlighter;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import java.awt.Dimension;
import java.util.Set;

public class FGPrimaryViewer
extends GraphViewer<FGVertex, FGEdge> {
    FGPrimaryViewer(FGComponent graphComponent, VisualGraphLayout<FGVertex, FGEdge> layout, Dimension size) {
        super(layout, size);
        this.setVertexTooltipProvider(new FGVertexTooltipProvider());
        this.setGraphOptions(graphComponent.getFucntionGraphOptions());
    }

    protected VisualGraphViewUpdater<FGVertex, FGEdge> createViewUpdater() {
        return new FGViewUpdater(this, (VisualGraph<FGVertex, FGEdge>)this.getVisualGraph());
    }

    protected VisualGraphPathHighlighter<FGVertex, FGEdge> createPathHighlighter(PathHighlightListener listener) {
        return new VisualGraphPathHighlighter<FGVertex, FGEdge>(this.getVisualGraph(), listener){

            protected GDirectedGraph<FGVertex, FGEdge> getDominanceGraph(VisualGraph<FGVertex, FGEdge> graph, boolean forward) {
                Set sources;
                Set set = sources = forward ? GraphAlgorithms.getSources(graph) : GraphAlgorithms.getSinks(graph);
                if (!sources.isEmpty()) {
                    return graph;
                }
                FunctionGraph functionGraph = (FunctionGraph)graph;
                Set<FGEdge> dummyEdges = forward ? functionGraph.createDummySources() : functionGraph.createDummySinks();
                MutableGDirectedGraphWrapper modifiedGraph = new MutableGDirectedGraphWrapper(graph);
                for (FGEdge e : dummyEdges) {
                    modifiedGraph.addEdge((GEdge)e);
                }
                return modifiedGraph;
            }
        };
    }
}

