/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import ghidra.app.nav.LocationMemento;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.framework.options.SaveState;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

public class FGLocationMemento
extends LocationMemento {
    private GraphPerspectiveInfo<FGVertex, FGEdge> info;

    FGLocationMemento(Program program, ProgramLocation location, GraphPerspectiveInfo<FGVertex, FGEdge> info) {
        super(program, location);
        this.info = info;
    }

    public FGLocationMemento(SaveState saveState, Program[] programs) {
        super(saveState, programs);
        this.info = new GraphPerspectiveInfo(saveState);
    }

    public void saveState(SaveState saveState) {
        super.saveState(saveState);
        this.info.saveState(saveState);
    }

    GraphPerspectiveInfo<FGVertex, FGEdge> getGraphPerspectiveInfo() {
        return this.info;
    }

    public String toString() {
        return "FG Memento [\n\tperspective=" + this.info + ",\n\taddress=" + this.programLocation.getAddress() + ",\n\tlocation=" + this.programLocation + "\n]";
    }
}

