/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.Settings;

public class FunctionNoReturnSettingsDefinition
implements BooleanSettingsDefinition {
    public static final FunctionNoReturnSettingsDefinition DEF = new FunctionNoReturnSettingsDefinition();
    private static final String NORETURN = "Show noreturn";
    private static final String NAME = "Show noreturn";
    private static final String DESCRIPTION = "On siganls to show the noreturn function attribute when present";
    private static final boolean DEFAULT = false;

    public boolean getValue(Settings settings) {
        if (settings == null) {
            return false;
        }
        String value = settings.getString("Show noreturn");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setValue(Settings settings, boolean value) {
        settings.setString("Show noreturn", Boolean.toString(value));
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        String value = srcSettings.getString("Show noreturn");
        if (value == null) {
            destSettings.clearSetting("Show noreturn");
        } else {
            destSettings.setString("Show noreturn", value);
        }
    }

    public void clear(Settings settings) {
        settings.clearSetting("Show noreturn");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return "Show noreturn";
    }

    public boolean hasValue(Settings settings) {
        return settings.getValue("Show noreturn") != null;
    }
}

