/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class StackFrameImpl
implements StackFrame {
    protected static final Variable[] emptyArray = new Variable[0];
    protected int localSize = 0;
    protected int returnStart = 0;
    protected List<Variable> variables = new ArrayList<Variable>();
    private final Function function;
    private final int paramStart;
    private final boolean growsNegative;

    StackFrameImpl(Function function) {
        this.function = function;
        this.growsNegative = function.getProgram().getCompilerSpec().stackGrowsNegative();
        Integer baseOffset = VariableUtilities.getBaseStackParamOffset((Function)function);
        this.paramStart = baseOffset != null ? (int)baseOffset.longValue() : 131072;
    }

    void variableChanged(LocalVariableImpl stackVar) {
        throw new UnsupportedOperationException();
    }

    public Variable createVariable(String name, int offset, DataType dataType, SourceType source) throws InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public Variable[] getStackVariables() {
        return this.getAllVariables();
    }

    public Variable[] getLocals() {
        if (this.getParameterOffset() >= 0) {
            return this.getNegativeVariables();
        }
        return this.getPositiveVariables();
    }

    public Variable[] getParameters() {
        return this.getParameterOffset() >= 0 ? this.getPositiveVariables() : this.getNegativeVariables();
    }

    public int getFrameSize() {
        int size = this.getLocalSize();
        return size += this.growsNegative() ? this.getPositiveSize() : this.getNegativeSize();
    }

    public int getLocalSize() {
        if (this.localSize > 0) {
            return this.localSize;
        }
        if (this.growsNegative()) {
            return this.getNegativeSize();
        }
        return this.getPositiveSize();
    }

    public boolean growsNegative() {
        return this.growsNegative;
    }

    public void setLocalSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getParameterSize() {
        if (this.growsNegative()) {
            return this.getPositiveSize() - this.getParameterOffset();
        }
        return this.getNegativeSize() + this.getParameterOffset();
    }

    public int getParameterCount() {
        if (this.growsNegative()) {
            return this.getPositiveCount();
        }
        return this.getNegativeCount();
    }

    public void clearVariable(int offset) {
        throw new UnsupportedOperationException();
    }

    public int getParameterOffset() {
        return this.paramStart;
    }

    public boolean isParameterOffset(int offset) {
        return this.growsNegative && offset >= this.paramStart || !this.growsNegative && offset < this.paramStart;
    }

    public int getReturnAddressOffset() {
        return this.returnStart;
    }

    public void setReturnAddressOffset(int offset) {
        throw new UnsupportedOperationException();
    }

    public Variable getVariableContaining(int offset) {
        Integer key = new Integer(offset);
        int index = Collections.binarySearch(this.variables, key, StackVariableComparator.get());
        if (index >= 0) {
            return this.variables.get(index);
        }
        index = -index - 1;
        if (--index < 0) {
            return null;
        }
        Variable var = this.variables.get(index);
        int stackOffset = var.getStackOffset();
        if (stackOffset + var.getLength() > offset) {
            if (var.getDataType().isDeleted()) {
                this.variables.remove(index);
            } else {
                return var;
            }
        }
        return null;
    }

    private int getNegativeSize() {
        int paramStart = this.getParameterOffset();
        if (this.variables.isEmpty()) {
            return this.growsNegative() ? 0 : -paramStart;
        }
        Variable var = this.variables.get(0);
        int stackOffset = var.getStackOffset();
        if (stackOffset >= 0) {
            return this.growsNegative() ? 0 : -paramStart;
        }
        return 0 - stackOffset;
    }

    private int getPositiveSize() {
        int paramStart = this.getParameterOffset();
        if (this.variables.isEmpty()) {
            return this.growsNegative() ? paramStart : 0;
        }
        Variable var = this.variables.get(this.variables.size() - 1);
        int stackOffset = var.getStackOffset();
        if (stackOffset < 0) {
            return this.growsNegative() ? paramStart : 0;
        }
        return stackOffset + var.getLength();
    }

    private Variable[] getNegativeVariables() {
        if (this.variables.isEmpty()) {
            return emptyArray;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length; ++index) {
            Variable var = this.variables.get(index);
            if (var.getDataType().isDeleted()) {
                this.variables.remove(index);
                continue;
            }
            int start = var.getStackOffset();
            if (start >= 0 || start > this.getParameterOffset()) break;
        }
        if (index == 0) {
            return emptyArray;
        }
        List<Variable> vars = this.variables.subList(0, index);
        int size = vars.size();
        Variable[] retvars = new Variable[size];
        int pos = size - 1;
        int i = 0;
        while (i < size) {
            retvars[pos] = vars.get(i);
            ++i;
            --pos;
        }
        return retvars;
    }

    private Variable[] getAllVariables() {
        if (this.variables.isEmpty()) {
            return emptyArray;
        }
        return this.variables.toArray(emptyArray);
    }

    private Variable[] getPositiveVariables() {
        if (this.variables.isEmpty()) {
            return emptyArray;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length; ++index) {
            Variable var = this.variables.get(index);
            if (var.getDataType().isDeleted()) {
                this.variables.remove(index);
                continue;
            }
            int start = var.getStackOffset();
            if (start >= 0 && start >= this.paramStart) break;
        }
        if (index == length) {
            return emptyArray;
        }
        List<Variable> vars = this.variables.subList(index, length);
        return vars.toArray(emptyArray);
    }

    private int getNegativeCount() {
        if (this.variables.isEmpty()) {
            return 0;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length; ++index) {
            Variable var = this.variables.get(index);
            if (var.getDataType().isDeleted()) {
                this.variables.remove(index);
                continue;
            }
            int start = var.getStackOffset();
            if (start >= 0 || start >= this.paramStart) break;
        }
        if (index == 0) {
            return 0;
        }
        return index;
    }

    private int getPositiveCount() {
        if (this.variables.isEmpty()) {
            return 0;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length; ++index) {
            Variable var = this.variables.get(index);
            if (var.getDataType().isDeleted()) {
                this.variables.remove(index);
                continue;
            }
            int start = var.getStackOffset();
            if (start >= 0 && start >= this.paramStart) break;
        }
        if (index == length) {
            return 0;
        }
        return length - index;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackFrame)) {
            return false;
        }
        StackFrame otherFrame = (StackFrame)obj;
        Variable[] otherVars = otherFrame.getStackVariables();
        if (this.getLocalSize() != otherFrame.getLocalSize() || this.paramStart != otherFrame.getParameterOffset() || this.returnStart != otherFrame.getReturnAddressOffset() || this.variables.size() != otherVars.length) {
            return false;
        }
        Iterator<Variable> myIter = this.variables.iterator();
        for (int i = 0; i < otherVars.length && myIter.hasNext(); ++i) {
            Variable myVar = myIter.next();
            if (myVar.equals(otherVars[i])) continue;
            return false;
        }
        return true;
    }
}

