/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

public class ProgramDiffFilter {
    public static final int PROGRAM_CONTEXT_DIFFS = 1;
    public static final int BYTE_DIFFS = 2;
    public static final int CODE_UNIT_DIFFS = 4;
    public static final int EOL_COMMENT_DIFFS = 8;
    public static final int PRE_COMMENT_DIFFS = 16;
    public static final int POST_COMMENT_DIFFS = 32;
    public static final int PLATE_COMMENT_DIFFS = 64;
    public static final int REPEATABLE_COMMENT_DIFFS = 128;
    public static final int REFERENCE_DIFFS = 256;
    public static final int EQUATE_DIFFS = 512;
    public static final int SYMBOL_DIFFS = 1024;
    public static final int FUNCTION_DIFFS = 2048;
    public static final int BOOKMARK_DIFFS = 4096;
    public static final int USER_DEFINED_DIFFS = 8192;
    public static final int FUNCTION_TAG_DIFFS = 16384;
    private static final int NUM_PRIMARY_TYPES = 15;
    public static final int COMMENT_DIFFS = 248;
    public static final int ALL_DIFFS = Short.MAX_VALUE;
    private int filterFlags = 0;

    public ProgramDiffFilter() {
    }

    public ProgramDiffFilter(ProgramDiffFilter filter) {
        this.filterFlags = filter.filterFlags;
    }

    public ProgramDiffFilter(int type) {
        this.filterFlags = Short.MAX_VALUE & type;
    }

    public boolean getFilter(int type) {
        return (type & this.filterFlags) != 0;
    }

    public synchronized void addToFilter(ProgramDiffFilter filter) {
        this.filterFlags |= filter.filterFlags;
    }

    public synchronized void setFilter(int type, boolean filter) {
        this.filterFlags = filter ? (this.filterFlags |= type) : (this.filterFlags &= ~type);
    }

    public void clearAll() {
        this.setFilter(Short.MAX_VALUE, false);
    }

    public void selectAll() {
        this.setFilter(Short.MAX_VALUE, true);
    }

    public static int[] getPrimaryTypes() {
        int[] pt = new int[15];
        for (int i = 0; i < 15; ++i) {
            pt[i] = 1 << i;
        }
        return pt;
    }

    public static String typeToName(int type) {
        switch (type) {
            case 2: {
                return "BYTE_DIFFS";
            }
            case 4: {
                return "CODE_UNIT_DIFFS";
            }
            case 248: {
                return "COMMENT_DIFFS";
            }
            case 8: {
                return "EOL_COMMENT_DIFFS";
            }
            case 16: {
                return "PRE_COMMENT_DIFFS";
            }
            case 32: {
                return "POST_COMMENT_DIFFS";
            }
            case 64: {
                return "PLATE_COMMENT_DIFFS";
            }
            case 128: {
                return "REPEATABLE_COMMENT_DIFFS";
            }
            case 256: {
                return "REFERENCE_DIFFS";
            }
            case 8192: {
                return "USER_DEFINED_DIFFS";
            }
            case 1024: {
                return "SYMBOL_DIFFS";
            }
            case 512: {
                return "EQUATE_DIFFS";
            }
            case 2048: {
                return "FUNCTION_DIFFS";
            }
            case 4096: {
                return "BOOKMARK_DIFFS";
            }
            case 1: {
                return "PROGRAM_CONTEXT_DIFFS";
            }
            case 32767: {
                return "ALL_DIFFS";
            }
            case 16384: {
                return "FUNCTION_TAG_DIFFS";
            }
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramDiffFilter) {
            return ((ProgramDiffFilter)obj).filterFlags == this.filterFlags;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProgramDiffFilter:\n");
        for (int i = 0; i < 15; ++i) {
            buf.append("  " + ProgramDiffFilter.typeToName(1 << i) + "=" + this.getFilter(1 << i) + "\n");
        }
        return buf.toString();
    }
}

