/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.util.XReferenceUtil;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.XRefFieldMouseHandler;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.program.util.VariableXRefFieldLocation;
import ghidra.program.util.VariableXRefHeaderFieldLocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class VariableXRefFieldMouseHandler
extends XRefFieldMouseHandler {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{VariableXRefFieldLocation.class, VariableXRefHeaderFieldLocation.class};

    @Override
    protected Address getToReferenceAddress(ProgramLocation programLocation, Program program) {
        Variable variable = ((VariableLocation)programLocation).getVariable();
        return variable.getMinAddress();
    }

    @Override
    protected Address getFromReferenceAddress(ProgramLocation programLocation) {
        return ((VariableXRefFieldLocation)programLocation).getRefAddress();
    }

    @Override
    protected ProgramLocation getReferredToLocation(Navigatable navigatable, ProgramLocation location) {
        VariableLocation variableLocation = (VariableLocation)location;
        Variable variable = variableLocation.getVariable();
        return new VariableNameFieldLocation(variable.getProgram(), variable, 0);
    }

    @Override
    protected int getIndex(ProgramLocation programLocation) {
        return ((VariableXRefFieldLocation)programLocation).getIndex();
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }

    @Override
    protected boolean isXREFHeaderLocation(ProgramLocation location) {
        return location instanceof VariableXRefHeaderFieldLocation;
    }

    @Override
    protected void showXRefDialog(Navigatable navigatable, ProgramLocation location, ServiceProvider serviceProvider) {
        TableService service = (TableService)serviceProvider.getService(TableService.class);
        if (service == null) {
            return;
        }
        Address toAddress = location.getAddress();
        Program program = navigatable.getProgram();
        VariableLocation variableLocation = (VariableLocation)location;
        Variable variable = variableLocation.getVariable();
        List<Reference> refs = this.getReferences(variable);
        this.showReferenceTable(navigatable, serviceProvider, service, toAddress, program, refs);
    }

    private List<Reference> getReferences(Variable variable) {
        ArrayList<Reference> refs = new ArrayList<Reference>();
        ArrayList<Reference> offcutRefs = new ArrayList<Reference>();
        XReferenceUtil.getVariableRefs(variable, refs, offcutRefs);
        HashSet<Reference> refsSet = new HashSet<Reference>(refs);
        HashSet<Reference> offcutRefsSet = new HashSet<Reference>(offcutRefs);
        refsSet.addAll(offcutRefsSet);
        return new ArrayList<Reference>(refsSet);
    }
}

