/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.demangler.DemangledTemplate;
import ghidra.app.util.demangler.DemanglerUtil;
import java.util.List;
import util.demangler.GenericDemangledTemplate;
import util.demangler.GenericDemangledType;

public class DemangledType {
    private String demangledName;
    private String name;
    protected String originalMangled;
    protected DemangledType namespace;
    protected DemangledTemplate template;
    private boolean isConst;
    private boolean isVolatile;

    public static DemangledType convertToNamespace(GenericDemangledType otherNamespace) {
        if (otherNamespace == null) {
            return null;
        }
        DemangledType newNamespace = new DemangledType(otherNamespace);
        String demangledName = newNamespace.getName();
        SymbolPath symbolPath = new SymbolPath(demangledName);
        if (symbolPath.getParent() == null) {
            return newNamespace;
        }
        List names = symbolPath.asList();
        DemangledType lastParent = new DemangledType((String)names.get(0));
        for (int i = 1; i < names.size(); ++i) {
            DemangledType child = new DemangledType((String)names.get(i));
            child.setNamespace(lastParent);
            lastParent = child;
        }
        return lastParent;
    }

    public DemangledType(String name) {
        this.setName(name);
    }

    DemangledType(GenericDemangledType toCopy) {
        GenericDemangledType otherNamespace = toCopy.getNamespace();
        if (otherNamespace != null) {
            this.namespace = DemangledType.convertToNamespace(otherNamespace);
        }
        this.setName(toCopy.getName());
        GenericDemangledTemplate otherTemplate = toCopy.getTemplate();
        if (otherTemplate != null) {
            this.template = new DemangledTemplate(otherTemplate);
        }
        this.isConst = toCopy.isConst();
        this.isVolatile = toCopy.isVolatile();
    }

    public String getDemangledName() {
        return this.demangledName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.demangledName = name;
        this.name = name;
        if (name != null) {
            this.name = DemanglerUtil.stripSuperfluousSignatureSpaces(name).replace(' ', '_');
        }
    }

    public void setOriginalMangled(String mangled) {
        this.originalMangled = mangled;
    }

    public String getOriginalMangled() {
        return this.originalMangled;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst() {
        this.isConst = true;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile() {
        this.isVolatile = true;
    }

    public DemangledType getNamespace() {
        return this.namespace;
    }

    public void setNamespace(DemangledType namespace) {
        if (this == namespace) {
            throw new IllegalArgumentException("Attempt to set this.namespace == this!");
        }
        this.namespace = namespace;
    }

    public DemangledTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(DemangledTemplate template) {
        this.template = template;
    }

    public String toSignature() {
        return this.toNamespace();
    }

    public String toNamespace() {
        StringBuffer buffer = new StringBuffer();
        if (this.namespace != null) {
            buffer.append(this.namespace.toNamespace());
        }
        buffer.append(this.demangledName);
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        if (buffer.length() == 0) {
            return "";
        }
        buffer.append("::");
        return buffer.toString();
    }

    public String toString() {
        return this.toNamespace();
    }
}

