/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CreateExternalFunctionCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledObjectFactory;
import ghidra.app.util.demangler.DemangledTemplate;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.ParameterReceiver;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledFunction;
import util.demangler.GenericDemangledObject;
import util.demangler.GenericDemangledTemplate;
import util.demangler.GenericDemangledType;

public class DemangledFunction
extends DemangledObject
implements ParameterReceiver {
    public static final String VOLATILE = "volatile";
    public static final String CONST = "const";
    public static final String PTR64 = "__ptr64";
    public static final String UNALIGNED = "__unaligned";
    public static final String RESTRICT = "__restrict";
    private static final String STD_NAMESPACE = "std";
    private static final String THIS_CALL = "__thiscall";
    protected DemangledDataType returnType;
    protected String callingConvention;
    protected boolean thisPassedOnStack = true;
    protected List<DemangledDataType> parameters = new ArrayList<DemangledDataType>();
    protected DemangledTemplate template;
    protected boolean isOverloadedOperator = false;
    private String templatedConstructorType;
    private boolean isTrailingConst;
    private boolean isTrailingVolatile;
    private boolean isTrailingPointer64;
    private boolean isTrailingUnaligned;
    private boolean isTrailingRestrict;
    private boolean isTypeCast;
    private String throwAttribute;

    public DemangledFunction(String name) {
        this.setName(name);
    }

    DemangledFunction(GenericDemangledFunction other) {
        super((GenericDemangledObject)other);
        GenericDemangledDataType otherReturnType = other.getReturnType();
        if (otherReturnType != null) {
            this.returnType = (DemangledDataType)DemangledObjectFactory.convert((GenericDemangledType)otherReturnType);
        }
        this.callingConvention = other.getCallingConvention();
        this.thisPassedOnStack = other.isPassedOnStack();
        GenericDemangledTemplate otherTemplate = other.getTemplate();
        if (otherTemplate != null) {
            this.template = new DemangledTemplate(otherTemplate);
        }
        this.isOverloadedOperator = other.isOverloadedOperator();
        List otherParams = other.getParameters();
        for (GenericDemangledDataType parameter : otherParams) {
            this.parameters.add((DemangledDataType)DemangledObjectFactory.convert((GenericDemangledType)parameter));
        }
    }

    public void setReturnType(DemangledDataType returnType) {
        this.returnType = returnType;
    }

    public void setCallingConvention(String callingConvention) {
        this.callingConvention = callingConvention;
    }

    public void setTemplate(DemangledTemplate template) {
        this.template = template;
    }

    public DemangledTemplate getTemplate() {
        return this.template;
    }

    public void setOverloadedOperator(boolean isOverloadedOperator) {
        this.isOverloadedOperator = isOverloadedOperator;
    }

    @Override
    public void addParameter(DemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public List<DemangledDataType> getParameters() {
        return new ArrayList<DemangledDataType>(this.parameters);
    }

    public DemangledDataType getReturnType() {
        return this.returnType;
    }

    public String getCallingConvention() {
        return this.callingConvention;
    }

    public void setTemplatedConstructorType(String type) {
        this.templatedConstructorType = type;
    }

    public boolean isTrailingConst() {
        return this.isTrailingConst;
    }

    public void setTrailingConst() {
        this.isTrailingConst = true;
    }

    public boolean isTrailingVolatile() {
        return this.isTrailingVolatile;
    }

    public void setTrailingVolatile() {
        this.isTrailingVolatile = true;
    }

    public boolean isTrailingPointer64() {
        return this.isTrailingPointer64;
    }

    public void setTrailingPointer64() {
        this.isTrailingPointer64 = true;
    }

    public boolean isTrailingUnaligned() {
        return this.isTrailingUnaligned;
    }

    public void setTrailingUnaligned() {
        this.isTrailingUnaligned = true;
    }

    public boolean isTrailingRestrict() {
        return this.isTrailingRestrict;
    }

    public void setTrailingRestrict() {
        this.isTrailingRestrict = true;
    }

    public boolean isTypeCast() {
        return this.isTypeCast;
    }

    public void setTypeCast() {
        this.isTypeCast = true;
    }

    public void setThrowAttribute(String throwAttribute) {
        this.throwAttribute = throwAttribute;
    }

    @Override
    public String getSignature(boolean format) {
        String pad;
        StringBuffer buffer = new StringBuffer();
        if (!(this.returnType instanceof DemangledFunctionPointer)) {
            buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
            if (this.isThunk) {
                buffer.append("[thunk]:");
            }
            buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
            if (this.isVirtual) {
                buffer.append("virtual ");
            }
            if (this.isStatic) {
                buffer.append("static ");
            }
            if (!this.isTypeCast()) {
                buffer.append((String)(this.returnType == null ? "" : this.returnType.toSignature() + " "));
            }
        }
        buffer.append((String)(this.callingConvention == null ? "" : this.callingConvention + " "));
        if (this.namespace != null) {
            buffer.append(this.namespace.toNamespace());
        }
        buffer.append(this.getDemangledName());
        if (this.isTypeCast()) {
            buffer.append((String)(this.returnType == null ? "" : " " + this.returnType.toSignature() + " "));
        }
        if (this.template != null) {
            buffer.append(this.template.toTemplate());
        }
        if (this.specialMidfix != null) {
            buffer.append('[').append(this.specialMidfix).append(']');
        }
        if (this.templatedConstructorType != null) {
            buffer.append('<').append(this.templatedConstructorType).append('>');
        }
        Iterator<DemangledDataType> paramIterator = this.parameters.iterator();
        buffer.append('(');
        String string = pad = format ? this.pad(buffer.length()) : "";
        if (!paramIterator.hasNext()) {
            buffer.append("void");
        }
        while (paramIterator.hasNext()) {
            buffer.append(paramIterator.next().toSignature());
            if (!paramIterator.hasNext()) continue;
            buffer.append(',');
            if (format) {
                buffer.append('\n');
            }
            buffer.append(pad);
        }
        buffer.append(')');
        buffer.append((String)(this.storageClass == null ? "" : " " + this.storageClass));
        if (this.returnType instanceof DemangledFunctionPointer) {
            DemangledFunctionPointer funcPtr = (DemangledFunctionPointer)this.returnType;
            String partialSig = funcPtr.toSignature(buffer.toString());
            buffer = new StringBuffer();
            buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
            buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
            if (this.isVirtual) {
                buffer.append("virtual ");
            }
            buffer.append(partialSig);
        } else if (this.specialSuffix != null) {
            buffer.append(this.specialSuffix);
        }
        if (this.isTrailingConst()) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(CONST);
        }
        if (this.isTrailingVolatile()) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(VOLATILE);
        }
        if (this.isTrailingUnaligned) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(UNALIGNED);
        }
        if (this.isTrailingPointer64) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(PTR64);
        }
        if (this.isTrailingRestrict) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(RESTRICT);
        }
        if (this.throwAttribute != null) {
            if (buffer.length() > 2) {
                buffer.append(" ");
            }
            buffer.append(this.throwAttribute);
        }
        return buffer.toString();
    }

    public String getParameterString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        Iterator<DemangledDataType> dditer = this.parameters.iterator();
        while (dditer.hasNext()) {
            buffer.append(dditer.next().toSignature());
            if (!dditer.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected boolean isAlreadyDemangled(Program program, Address address) {
        Function f = program.getListing().getFunctionAt(address);
        if (f != null && f.getSymbol().getSource() == SourceType.USER_DEFINED) {
            return true;
        }
        if (f == null || f.getSignatureSource() == SourceType.DEFAULT || f.getSignatureSource() == SourceType.ANALYSIS) {
            return false;
        }
        return super.isAlreadyDemangled(program, address);
    }

    @Override
    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        if (this.isAlreadyDemangled(program, address)) {
            return true;
        }
        if (!super.applyTo(program, address, options, monitor)) {
            return false;
        }
        Function function = DemangledFunction.createFunction(program, address, options.doDisassembly(), monitor);
        if (function == null) {
            return false;
        }
        boolean makePrimary = function.getSignatureSource() != SourceType.USER_DEFINED;
        Symbol demangledSymbol = this.applyDemangledName(function.getEntryPoint(), makePrimary, false, program);
        if (demangledSymbol == null) {
            return false;
        }
        if (!options.applySignature() || function.getSignatureSource() == SourceType.USER_DEFINED) {
            return true;
        }
        Structure classStructure = this.maybeUpdateCallingConventionAndCreateClass(program, function);
        FunctionDefinitionDataType signature = new FunctionDefinitionDataType(function, true);
        List<ParameterDefinitionImpl> args = this.convertMangledToParamDef(program);
        signature.setArguments(args.toArray(new ParameterDefinition[args.size()]));
        if (this.hasVarArgs()) {
            signature.setVarArgs(true);
        }
        if (!function.isExternal() && this.isParameterMismatch(function, (FunctionSignature)signature)) {
            this.bookmarkParameterMismatch(program, function.getEntryPoint(), args);
            return true;
        }
        DataType resolvedReturnType = this.resolveReturnType(program, function, classStructure);
        if (resolvedReturnType != null) {
            signature.setReturnType(resolvedReturnType);
        }
        ApplyFunctionSignatureCmd cmd = new ApplyFunctionSignatureCmd(function.getEntryPoint(), (FunctionSignature)signature, SourceType.IMPORTED, true, false);
        cmd.applyTo((DomainObject)program);
        return true;
    }

    private boolean hasVarArgs() {
        if (this.parameters.isEmpty()) {
            return false;
        }
        DemangledDataType lastType = this.parameters.get(this.parameters.size() - 1);
        return lastType.isVarArgs();
    }

    private boolean hasVoidParams() {
        if (this.parameters.size() == 1) {
            DemangledDataType ddt = this.parameters.get(0);
            return ddt.isVoid() && !ddt.isPointer();
        }
        return false;
    }

    private void bookmarkParameterMismatch(Program program, Address address, List<ParameterDefinitionImpl> args) {
        if (this.parameters.isEmpty()) {
            return;
        }
        int pointerSize = program.getDefaultPointerSize();
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i).getLength() <= pointerSize) continue;
            bookmarkManager.setBookmark(address, "Analysis", "Demangler", "Couldn't Apply demangled signature - probably due to datatype that is too large to fit in a parameter");
        }
        bookmarkManager.setBookmark(address, "Analysis", "Demangler", "Couldn't Apply demangled signature - bad parameter number match (" + args.size() + ") in a function in a namespace");
    }

    static void maybeCreateUndefined(Program program, Address address) {
        Listing listing = program.getListing();
        Instruction instruction = listing.getInstructionContaining(address);
        if (instruction != null) {
            return;
        }
        Data data = listing.getDefinedDataContaining(address);
        if (data != null) {
            return;
        }
        DataType demangledDT = Undefined.getUndefinedDataType((int)1);
        try {
            listing.createData(address, demangledDT);
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
        }
        catch (DataTypeConflictException dataTypeConflictException) {
            // empty catch block
        }
    }

    private DataType resolveReturnType(Program program, Function func, Structure classDataType) {
        String n;
        if (this.returnType != null) {
            return this.returnType.getDataType(program.getDataTypeManager());
        }
        if (THIS_CALL.equals(func.getCallingConventionName()) && ((n = this.getName()).equals("~" + this.namespace.getName()) || n.equals(this.namespace.getName()))) {
            return VoidDataType.dataType;
        }
        return null;
    }

    private Structure maybeUpdateCallingConventionAndCreateClass(Program program, Function func) {
        try {
            if (this.callingConvention != null) {
                if (program.getCompilerSpec().getCallingConvention(this.callingConvention) == null) {
                    program.getBookmarkManager().setBookmark(func.getEntryPoint(), "Analysis", "Demangler", "Warning calling convention \"" + this.callingConvention + "\" not defined in Compiler Spec (.cspec)");
                } else {
                    func.setCallingConvention(this.callingConvention);
                    if (THIS_CALL.equals(this.callingConvention)) {
                        return this.createClassStructure(program, func);
                    }
                    return null;
                }
            }
            if (this.isThisCall(func)) {
                func.setCallingConvention(THIS_CALL);
                return this.createClassStructure(program, func);
            }
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<ParameterDefinitionImpl> convertMangledToParamDef(Program program) {
        ArrayList<ParameterDefinitionImpl> args = new ArrayList<ParameterDefinitionImpl>();
        for (DemangledDataType param : this.parameters) {
            if (param.isVoid() && !param.isPointer() || param.isVarArgs()) break;
            DataType dt = param.getDataType(program.getDataTypeManager());
            args.add(new ParameterDefinitionImpl(null, dt, null));
        }
        return args;
    }

    private boolean isParameterMismatch(Function func, FunctionSignature signature) {
        int existingParameterCount = func.getParameterCount();
        if (this.namespace == null || this.namespace.getName().startsWith("__")) {
            return false;
        }
        String callingConventionName = func.getCallingConventionName();
        if (existingParameterCount == 0 && THIS_CALL.equals(callingConventionName)) {
            return false;
        }
        if (func.getSignatureSource() == SourceType.DEFAULT) {
            return false;
        }
        int mangledParamterCount = this.parameters.size();
        if (this.hasVoidParams()) {
            mangledParamterCount = 0;
        }
        boolean hasVarArgs = false;
        if (mangledParamterCount != 0 && (hasVarArgs = this.hasVarArgs())) {
            --mangledParamterCount;
        }
        if (hasVarArgs != func.hasVarArgs()) {
            return true;
        }
        if (existingParameterCount == 0 && mangledParamterCount > 0) {
            if (this.isOverloadedOperator && this.parameters.size() <= 2) {
                return false;
            }
            PrototypeModel[] specs = func.getProgram().getCompilerSpec().getCallingConventions();
            return specs != null && specs.length != 1;
        }
        return false;
    }

    private boolean isThisCall(Function func) {
        Function newfunc;
        if (this.namespace == null || StringUtils.isBlank((CharSequence)this.namespace.getName())) {
            return false;
        }
        if (this.isInStdNameSpace()) {
            return false;
        }
        int mangledParameterCount = this.parameters.size();
        if (this.isOverloadedOperator && mangledParameterCount <= 1) {
            return true;
        }
        if (this.isOverloadedOperator && mangledParameterCount == 2) {
            return false;
        }
        String n = this.getName();
        if (n.startsWith("~")) {
            return true;
        }
        if (n.startsWith(this.namespace.getName())) {
            return true;
        }
        Program program = func.getProgram();
        Data data = program.getListing().getDefinedDataAt(func.getEntryPoint());
        if (data != null && data.getAddress(0) != null && (newfunc = program.getFunctionManager().getFunctionAt(data.getAddress(0))) != null) {
            if (THIS_CALL.equals(newfunc.getCallingConventionName())) {
                return true;
            }
            func = newfunc;
        }
        return func.getParameterCount() == mangledParameterCount + 1;
    }

    private boolean isInStdNameSpace() {
        DemangledType ns = this.namespace;
        if (ns == null) {
            return false;
        }
        return ns.getName().toLowerCase().equals(STD_NAMESPACE);
    }

    static Function createFunction(Program prog, Address addr, boolean doDisassembly, TaskMonitor monitor) {
        Listing listing = prog.getListing();
        Function func = listing.getFunctionAt(addr);
        if (func != null) {
            return func;
        }
        if (addr.isExternalAddress()) {
            Symbol extSymbol = prog.getSymbolTable().getPrimarySymbol(addr);
            CreateExternalFunctionCmd cmd = new CreateExternalFunctionCmd(extSymbol);
            cmd.applyTo((DomainObject)prog);
        } else {
            AddressSetView execSet;
            if (doDisassembly && (execSet = prog.getMemory().getExecuteSet()).contains(addr)) {
                DisassembleCommand cmd = new DisassembleCommand(addr, null, true);
                cmd.applyTo((DomainObject)prog, monitor);
            }
            CreateFunctionCmd cmd = new CreateFunctionCmd(addr);
            cmd.applyTo((DomainObject)prog, monitor);
        }
        return listing.getFunctionAt(addr);
    }
}

