/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexTypeDefOrRef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableEvent
extends CliAbstractTable {
    public CliTableEvent(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliEventRow row = new CliEventRow(reader.readNextShort(), this.readStringIndex(reader), CliIndexTypeDefOrRef.readCodedIndex(reader, stream));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "Event Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumEventAttributes.dataType, "EventFlags", null);
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", null);
        rowDt.add(CliIndexTypeDefOrRef.toDataType(this.metadataStream), "EventType", "type of Event, not of owning class");
        return rowDt;
    }

    public class CliEventRow
    extends CliAbstractTableRow {
        public short eventFlags;
        public int nameIndex;
        public int eventTypeIndex;

        public CliEventRow(short eventFlags, int nameIndex, int eventTypeIndex) {
            this.eventFlags = eventFlags;
            this.nameIndex = nameIndex;
            this.eventTypeIndex = eventTypeIndex;
        }

        @Override
        public String getRepresentation() {
            String eventRep;
            try {
                eventRep = CliTableEvent.this.getRowRepresentationSafe(CliIndexTypeDefOrRef.getTableName(this.eventTypeIndex), CliIndexTypeDefOrRef.getRowIndex(this.eventTypeIndex));
            }
            catch (InvalidInputException e) {
                eventRep = Integer.toHexString(this.eventTypeIndex);
            }
            return String.format("%s Flags %s Type %s", CliTableEvent.this.metadataStream.getStringsStream().getString(this.nameIndex), CliFlags.CliEnumEventAttributes.dataType.getName(this.eventFlags & 0xFFFF), eventRep);
        }
    }
}

