/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateX86;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadStateX86_64
extends ThreadStateX86 {
    public long rax;
    public long rbx;
    public long rcx;
    public long rdx;
    public long rdi;
    public long rsi;
    public long rbp;
    public long rsp;
    public long r8;
    public long r9;
    public long r10;
    public long r11;
    public long r12;
    public long r13;
    public long r14;
    public long r15;
    public long rip;
    public long rflags;
    public long cs;
    public long fs;
    public long gs;

    static ThreadStateX86_64 createThreadStateX86_64(FactoryBundledWithBinaryReader reader) throws IOException {
        ThreadStateX86_64 threadStateX86_64 = (ThreadStateX86_64)reader.getFactory().create(ThreadStateX86_64.class, new Object[0]);
        threadStateX86_64.initThreadStateX86_64(reader);
        return threadStateX86_64;
    }

    private void initThreadStateX86_64(FactoryBundledWithBinaryReader reader) throws IOException {
        this.rax = reader.readNextLong();
        this.rbx = reader.readNextLong();
        this.rcx = reader.readNextLong();
        this.rdx = reader.readNextLong();
        this.rdi = reader.readNextLong();
        this.rsi = reader.readNextLong();
        this.rbp = reader.readNextLong();
        this.rsp = reader.readNextLong();
        this.r8 = reader.readNextLong();
        this.r9 = reader.readNextLong();
        this.r10 = reader.readNextLong();
        this.r11 = reader.readNextLong();
        this.r12 = reader.readNextLong();
        this.r13 = reader.readNextLong();
        this.r14 = reader.readNextLong();
        this.r15 = reader.readNextLong();
        this.rip = reader.readNextLong();
        this.rflags = reader.readNextLong();
        this.cs = reader.readNextLong();
        this.fs = reader.readNextLong();
        this.gs = reader.readNextLong();
    }

    @Override
    public long getInstructionPointer() {
        return this.rip;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("x86_THREAD_STATE64", 0);
        struct.add(QWORD, "rax", null);
        struct.add(QWORD, "rbx", null);
        struct.add(QWORD, "cx", null);
        struct.add(QWORD, "rdx", null);
        struct.add(QWORD, "rdi", null);
        struct.add(QWORD, "rsi", null);
        struct.add(QWORD, "rbp", null);
        struct.add(QWORD, "rsp", null);
        struct.add(QWORD, "r8", null);
        struct.add(QWORD, "r9", null);
        struct.add(QWORD, "r10", null);
        struct.add(QWORD, "r11", null);
        struct.add(QWORD, "r12", null);
        struct.add(QWORD, "r13", null);
        struct.add(QWORD, "r14", null);
        struct.add(QWORD, "r15", null);
        struct.add(QWORD, "rip", null);
        struct.add(QWORD, "rflags", null);
        struct.add(QWORD, "cs", null);
        struct.add(QWORD, "fs", null);
        struct.add(QWORD, "gs", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

