/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ByteProviderWrapper
implements ByteProvider {
    private ByteProvider provider;
    private long subOffset;
    private long subLength;

    public ByteProviderWrapper(ByteProvider provider, long subOffset, long subLength) {
        this.provider = provider;
        this.subOffset = subOffset;
        this.subLength = subLength;
    }

    @Override
    public void close() {
    }

    @Override
    public File getFile() {
        return this.provider.getFile();
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        return this.provider.getInputStream(this.subOffset + index);
    }

    @Override
    public String getName() {
        return this.provider.getName() + "[0x" + Long.toHexString(this.subOffset) + ",0x" + Long.toHexString(this.subLength) + "]";
    }

    @Override
    public String getAbsolutePath() {
        return this.provider.getAbsolutePath() + "[0x" + Long.toHexString(this.subOffset) + ",0x" + Long.toHexString(this.subLength) + "]";
    }

    @Override
    public long length() throws IOException {
        return this.subLength;
    }

    @Override
    public boolean isValidIndex(long index) {
        if (this.provider.isValidIndex(index)) {
            return index >= this.subOffset && index < this.subLength;
        }
        return false;
    }

    @Override
    public byte readByte(long index) throws IOException {
        return this.provider.readByte(this.subOffset + index);
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        return this.provider.readBytes(this.subOffset + index, length);
    }
}

