/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.MultiLineLabel;
import docking.widgets.list.ListPanel;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PickProviderDialog
extends DialogComponentProvider {
    private List<GhidraScriptProvider> providers;
    private ListPanel listPanel;
    private JComponent parent;
    private boolean wasCancelled;
    private static String lastSelectedProviderDescription;

    PickProviderDialog(JComponent parent, HelpLocation help) {
        super("New Script: Type");
        this.parent = parent;
        this.providers = GhidraScriptUtil.getProviders();
        DefaultListModel<GhidraScriptProvider> listModel = new DefaultListModel<GhidraScriptProvider>();
        for (GhidraScriptProvider provider : this.providers) {
            listModel.addElement(provider);
        }
        this.addWorkPanel(this.buildWorkPanel(listModel));
        this.addOKButton();
        this.addCancelButton();
        this.rootPanel.setPreferredSize(new Dimension(300, 225));
        this.setHelpLocation(help);
    }

    public PickProviderDialog(List<String> testItems, String defaultItem) {
        super("New Script: Type");
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String item : testItems) {
            listModel.addElement(item);
        }
        this.addWorkPanel(this.buildWorkPanel(listModel));
        this.addOKButton();
        this.addCancelButton();
        this.rootPanel.setPreferredSize(new Dimension(300, 225));
        if (defaultItem != null) {
            this.listPanel.setSelectedValue((Object)defaultItem);
        }
    }

    void setSelectedProvider(GhidraScriptProvider provider) {
        this.listPanel.setSelectedValue((Object)provider);
    }

    GhidraScriptProvider getSelectedProvider() {
        if (this.providers.size() == 1) {
            return this.providers.get(0);
        }
        this.selectBestProvider();
        DockingWindowManager.showDialog((Component)this.parent, (DialogComponentProvider)this);
        if (this.wasCancelled) {
            return null;
        }
        return (GhidraScriptProvider)this.listPanel.getSelectedValue();
    }

    public void dispose() {
        this.close();
    }

    private void selectBestProvider() {
        if (lastSelectedProviderDescription != null) {
            for (GhidraScriptProvider provider : this.providers) {
                if (!provider.getDescription().equals(lastSelectedProviderDescription)) continue;
                this.listPanel.setSelectedValue((Object)provider);
                return;
            }
        }
        for (GhidraScriptProvider provider : this.providers) {
            if (!"Java".equals(provider.getDescription())) continue;
            this.listPanel.setSelectedValue((Object)provider);
            return;
        }
    }

    protected void cancelCallback() {
        this.wasCancelled = true;
        super.cancelCallback();
    }

    protected void okCallback() {
        GhidraScriptProvider provider = (GhidraScriptProvider)this.listPanel.getSelectedValue();
        if (provider != null) {
            lastSelectedProviderDescription = provider.getDescription();
        }
        this.close();
    }

    private JPanel buildWorkPanel(DefaultListModel<?> listModel) {
        this.listPanel = new ListPanel();
        this.listPanel.setListModel(listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.setDoubleClickActionListener(e -> this.close());
        JPanel workPanel = new JPanel(new BorderLayout());
        MultiLineLabel mll = new MultiLineLabel("\nPlease select a script type:");
        workPanel.add((Component)mll, "North");
        workPanel.add((Component)this.listPanel, "Center");
        return workPanel;
    }
}

