/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.module;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Program Tree", shortDescription="Sort Fragments within Module", description="Plugin to sort Modules and Fragments within a selected Module. Child Module folders are always name-sorted and placed above child Fragments.  When sorting on address, the minimum address for each fragment is used, while empty fragments are name-sorted  and placed at the bottom.")
public class ModuleSortPlugin
extends ProgramPlugin {
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_ADDRESS = 2;
    private static final String[] SORT_BY_ADDR_MENUPATH = new String[]{"Sort", "by Address"};
    private ModuleSortAction sortByAddrAction;
    private static final String[] SORT_BY_NAME_MENUPATH = new String[]{"Sort", "by Name"};
    private ModuleSortAction sortByNameAction;

    public ModuleSortPlugin(PluginTool tool) {
        super(tool, false, false);
        this.createActions();
    }

    private void createActions() {
        this.sortByAddrAction = new ModuleSortAction("Sort Fragments By Address", this.getName(), 2);
        this.sortByNameAction = new ModuleSortAction("Sort Fragments By Name", this.getName(), 1);
        this.tool.addAction((DockingActionIf)this.sortByAddrAction);
        this.tool.addAction((DockingActionIf)this.sortByNameAction);
    }

    private void moduleSortCallback(int sortType, Object contextObj) {
        ProgramModule module = this.getSelectedModule(contextObj);
        if (module == null) {
            return;
        }
        TaskBuilder.withTask((Task)new SortTask(module, sortType)).setStatusTextAlignment(10).launchModal();
    }

    private void doSort(ProgramModule parent, GroupComparator comparator, TaskMonitor monitor) throws NotFoundException, CancelledException {
        ArrayList<Group> list = new ArrayList<Group>();
        Group[] kids = parent.getChildren();
        monitor.initialize((long)kids.length);
        for (Group kid : kids) {
            monitor.checkCanceled();
            list.add(kid);
            if (kid instanceof ProgramModule) {
                this.doSort((ProgramModule)kid, comparator, monitor);
            }
            monitor.incrementProgress(1L);
        }
        Collections.sort(list, comparator);
        monitor.initialize((long)list.size());
        for (int i = 0; i < list.size(); ++i) {
            monitor.checkCanceled();
            Group group = (Group)list.get(i);
            monitor.setMessage("processing " + group.getName());
            parent.moveChild(group.getName(), i);
            monitor.incrementProgress(1L);
            if (i % 10 != 0) continue;
            this.allowSwingThreadToPaintBetweenLongLocking();
        }
    }

    private void allowSwingThreadToPaintBetweenLongLocking() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ProgramModule getSelectedModule(Object contextObj) {
        ProgramNode node;
        if (contextObj instanceof ProgramNode && (node = (ProgramNode)contextObj).isModule() && node.getTree().getSelectionCount() == 1) {
            return node.getModule();
        }
        return null;
    }

    class ModuleSortAction
    extends DockingAction {
        private int sortType;

        public ModuleSortAction(String name, String owner, int sortType) {
            super(name, owner);
            this.sortType = sortType;
            if (sortType == 2) {
                this.setPopupMenuData(new MenuData(SORT_BY_ADDR_MENUPATH, null, "module"));
                this.setDescription("Perform a minimum address sort of all fragments contained within a selected folder");
            } else {
                this.setPopupMenuData(new MenuData(SORT_BY_NAME_MENUPATH, null, "module"));
                this.setDescription("Perform a name sort of all fragments contained within a selected folder");
            }
            this.setEnabled(true);
            this.setHelpLocation(new HelpLocation("ProgramTreePlugin", "SortByAddressOrName"));
        }

        public boolean isEnabledForContext(ActionContext context) {
            ProgramNode node;
            Object activeObj = context.getContextObject();
            return activeObj != null && activeObj instanceof ProgramNode && (node = (ProgramNode)activeObj).getProgram() != null && node.isModule() && node.getTree().getSelectionCount() == 1;
        }

        public void actionPerformed(ActionContext context) {
            ModuleSortPlugin.this.moduleSortCallback(this.sortType, context.getContextObject());
        }
    }

    private class GroupComparator
    implements Comparator<Group> {
        private int sortType;

        GroupComparator(int sortType) {
            this.sortType = sortType;
        }

        @Override
        public int compare(Group g1, Group g2) {
            if (this.sortType == 2) {
                ProgramModule m;
                Address addr1 = null;
                Address addr2 = null;
                if (g1 instanceof ProgramFragment) {
                    addr1 = ((ProgramFragment)g1).getMinAddress();
                } else {
                    m = (ProgramModule)g1;
                    addr1 = m.getAddressSet().getMinAddress();
                }
                if (g2 instanceof ProgramFragment) {
                    addr2 = ((ProgramFragment)g2).getMinAddress();
                } else {
                    m = (ProgramModule)g2;
                    addr2 = m.getAddressSet().getMinAddress();
                }
                if (addr1 == null && addr2 == null) {
                    return 0;
                }
                if (addr1 != null && addr2 == null) {
                    return -1;
                }
                if (addr1 == null) {
                    return 1;
                }
                return addr1.compareTo((Object)addr2);
            }
            return g1.getName().compareTo(g2.getName());
        }
    }

    private class SortTask
    extends Task {
        private GroupComparator comparator;
        private ProgramModule module;

        SortTask(ProgramModule module, int sortType) {
            super("Sort " + (sortType == 2 ? " by Address" : " by Name"), true, true, true, true);
            this.module = module;
            this.comparator = new GroupComparator(sortType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            int txId = -1;
            boolean success = false;
            try {
                txId = ModuleSortPlugin.this.currentProgram.startTransaction(ModuleSortPlugin.this.getName());
                ModuleSortPlugin.this.doSort(this.module, this.comparator, monitor);
                success = true;
            }
            catch (CancelledException cancelledException) {
            }
            catch (Throwable t) {
                Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Module Sort Failed", (Throwable)t);
            }
            finally {
                ModuleSortPlugin.this.currentProgram.endTransaction(txId, success);
            }
        }
    }
}

