/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.ModifiableAddressSetCollection;
import ghidra.app.plugin.core.marker.NavigationPanel;
import ghidra.app.plugin.core.marker.PointMarkerSet;
import ghidra.app.services.MarkerListener;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetCollection;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.SortedRangeList;
import java.awt.Color;
import java.awt.Graphics;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

abstract class MarkerSetImpl
implements MarkerSet {
    protected MarkerManager mgr;
    private String name;
    protected String description;
    protected int priority = 0;
    protected boolean active = true;
    protected AddressSetCollection markers;
    protected SortedRangeList overview = null;
    protected List<Integer> activeLayouts = null;
    protected Color markerColor;
    protected int lastHeight = 1;
    protected int lastWidth = 16;
    protected MarkerListener listener;
    protected static final int MARKER_WIDTH_OFFSET = 7;
    protected static final int MARKER_HEIGHT = 4;
    private static final int COLOR_VALUE = 200;
    private boolean showMarkers;
    private boolean showNavigation;
    private boolean colorBackground;
    private boolean isPreferred;

    MarkerSetImpl(MarkerManager mgr, String name, String desc, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color markerColor, boolean isPreferred) {
        this.mgr = mgr;
        this.name = name;
        this.description = desc;
        this.priority = priority;
        this.showMarkers = showMarkers;
        this.showNavigation = showNavigation;
        this.colorBackground = colorBackground;
        this.markerColor = markerColor;
        this.isPreferred = isPreferred;
        if (markerColor == null) {
            throw new NullPointerException("Marker color can't be null");
        }
        this.markers = new ModifiableAddressSetCollection();
    }

    protected abstract void doPaintMarkers(Graphics var1, VerticalPixelAddressMap var2, int var3, AddressIndexMap var4, List<Integer> var5);

    protected abstract void doPaintNavigation(Graphics var1, int var2, int var3, SortedRangeList var4);

    public abstract ImageIcon getNavIcon();

    @Override
    public void setNavigationListener(MarkerListener listener) {
        this.listener = listener;
    }

    @Override
    public Color getMarkerColor() {
        return this.markerColor;
    }

    @Override
    public void setMarkerColor(Color markerColor) {
        this.markerColor = markerColor;
        this.mgr.update();
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isPreferred() {
        return this.isPreferred;
    }

    @Override
    public void setAddressSetCollection(AddressSetCollection set) {
        if (set == null) {
            set = new ModifiableAddressSetCollection();
        }
        this.markers = set;
        this.clearAndUpdate();
    }

    @Override
    public void setAddressSet(AddressSetView set) {
        this.markers = new ModifiableAddressSetCollection();
        if (set != null) {
            this.add(set);
        }
    }

    @Override
    public void add(Address addr) {
        this.add(addr, addr);
    }

    @Override
    public void add(AddressRange range) {
        this.add(range.getMinAddress(), range.getMaxAddress());
    }

    @Override
    public void add(Address start, Address end) {
        this.checkModifiable();
        ((ModifiableAddressSetCollection)this.markers).addRange(start, end);
        this.clearAndUpdate();
    }

    @Override
    public void add(AddressSetView addrSet) {
        this.checkModifiable();
        ((ModifiableAddressSetCollection)this.markers).add(addrSet);
        this.clearAndUpdate();
    }

    @Override
    public void clear(Address start, Address end) {
        this.checkModifiable();
        ((ModifiableAddressSetCollection)this.markers).deleteRange(start, end);
        this.clearAndUpdate();
    }

    private void checkModifiable() {
        if (!(this.markers instanceof ModifiableAddressSetCollection)) {
            throw new IllegalStateException("Attempted to modify a read-only marker set.");
        }
    }

    @Override
    public void clear(AddressRange range) {
        this.clear(range.getMinAddress(), range.getMaxAddress());
    }

    @Override
    public void clear(Address address) {
        this.clear(address, address);
    }

    @Override
    public void clear(AddressSetView addrSet) {
        this.checkModifiable();
        ((ModifiableAddressSetCollection)this.markers).delete(addrSet);
        this.clearAndUpdate();
    }

    @Override
    public void clearAll() {
        this.markers = new ModifiableAddressSetCollection();
        this.clearAndUpdate();
    }

    private void clearAndUpdate() {
        this.assertSwing();
        this.overview = null;
        this.activeLayouts = null;
        this.mgr.update();
    }

    void updateView(boolean updateMarkers, boolean updateNavigation) {
        if (updateMarkers) {
            this.activeLayouts = null;
        }
        if (updateNavigation) {
            this.overview = null;
        }
    }

    public final void paintMarkers(Graphics g, int index, VerticalPixelAddressMap pixmap, AddressIndexMap map) {
        if (this.showMarkers) {
            List<Integer> layouts = this.computeActiveLayouts(pixmap, map);
            this.doPaintMarkers(g, pixmap, index, map, layouts);
        }
    }

    public final void paintNavigation(Graphics g, int height, NavigationPanel panel, AddressIndexMap map) {
        if (this.showNavigation) {
            SortedRangeList newOverview = this.computeNavigationIndexes(height, map);
            this.doPaintNavigation(g, height, panel.getWidth(), newOverview);
        }
    }

    protected static Color getFillColor(Color c) {
        int red = (c.getRed() + 600) / 4;
        int green = (c.getGreen() + 600) / 4;
        int blue = (c.getBlue() + 600) / 4;
        return new Color(red, green, blue);
    }

    @Override
    public int compareTo(MarkerSet other) {
        int result = 1;
        if (other != null) {
            result = this.isPreferred() == other.isPreferred() ? this.priority - other.getPriority() : (this.isPreferred() ? 1 : -1);
        }
        return result;
    }

    @Override
    public boolean contains(Address addr) {
        this.assertSwing();
        return this.markers.contains(addr);
    }

    private List<Integer> computeActiveLayouts(VerticalPixelAddressMap pixmap, AddressIndexMap map) {
        if (pixmap == null) {
            return null;
        }
        if (this.activeLayouts != null) {
            return this.activeLayouts;
        }
        ArrayList<Integer> newLayouts = new ArrayList<Integer>();
        int n = pixmap.getNumLayouts();
        for (int i = 0; i < n; ++i) {
            Address end;
            Address addr = pixmap.getLayoutAddress(i);
            if (addr == null || !this.markers.intersects(addr, end = pixmap.getLayoutEndAddress(i))) continue;
            newLayouts.add(new Integer(i));
        }
        this.activeLayouts = newLayouts;
        return newLayouts;
    }

    private SortedRangeList computeNavigationIndexes(int height, AddressIndexMap map) {
        this.lastHeight = height;
        double numIndexes = map.getIndexCount().doubleValue();
        if (this.markers.isEmpty() || height == 0 || numIndexes == 0.0) {
            return null;
        }
        if (this.overview != null) {
            return this.overview;
        }
        SortedRangeList newOverview = new SortedRangeList();
        double indexSize = numIndexes / (double)height;
        if (numIndexes < (double)height && this instanceof PointMarkerSet) {
            int nIndexes = map.getIndexCount().intValue();
            for (int i = 0; i < nIndexes; ++i) {
                Address addr = map.getAddress(BigInteger.valueOf(i));
                if (addr == null || !this.markers.contains(addr)) continue;
                int index = (int)((double)i / indexSize);
                newOverview.addRange(index, index);
            }
        } else if (this.markers.hasFewerRangesThan(height)) {
            FieldSelection sel = map.getFieldSelection((AddressSetView)this.markers.getCombinedAddressSet());
            int n = sel.getNumRanges();
            for (int i = 0; i < n; ++i) {
                FieldRange range = sel.getFieldRange(i);
                int start = (int)(range.getStart().getIndex().doubleValue() / indexSize);
                int end = (int)(range.getEnd().getIndex().doubleValue() / indexSize);
                newOverview.addRange(start, end);
            }
        } else {
            BigInteger startIndex = BigInteger.ZERO;
            for (int i = 0; i < height; ++i) {
                BigInteger endIndex = BigDecimal.valueOf((double)(i + 1) * indexSize).toBigInteger();
                int compareTo = startIndex.compareTo(endIndex);
                if (compareTo > 0) {
                    BigInteger tmp = startIndex;
                    startIndex = endIndex;
                    endIndex = tmp;
                } else if (compareTo == 0) {
                    endIndex = startIndex.add(BigInteger.ONE);
                }
                if (endIndex.compareTo(map.getIndexCount()) >= 0) {
                    endIndex = map.getIndexCount();
                }
                FieldSelection fs = new FieldSelection();
                fs.addRange(startIndex, endIndex);
                AddressSet set = map.getAddressSet(fs);
                if (this.markers.intersects((AddressSetView)set)) {
                    newOverview.addRange(i, i);
                }
                startIndex = endIndex;
            }
        }
        this.overview = newOverview;
        return newOverview;
    }

    public String getTooltip(Address addr, int x, int y) {
        if (this.listener != null) {
            return this.listener.getTooltip(new MarkerLocation(this, addr, x, y));
        }
        return null;
    }

    @Override
    public boolean isDisplayedInNavigationBar() {
        return this.showNavigation;
    }

    @Override
    public boolean displayInMarkerBar() {
        return this.showMarkers;
    }

    @Override
    public boolean isColoringBackground() {
        return this.colorBackground;
    }

    @Override
    public void setColoringBackground(boolean b) {
        this.colorBackground = b;
        this.mgr.update();
    }

    public ProgramLocation getProgramLocation(int y, int height, AddressIndexMap map, int x) {
        this.assertSwing();
        if (this.overview == null) {
            return null;
        }
        ProgramLocation loc = null;
        if (this.overviewContains(y)) {
            if ((y -= 3) < 0) {
                y = 0;
            }
            BigDecimal bigHeight = BigDecimal.valueOf(height);
            BigInteger bigStarty = BigInteger.valueOf(y);
            BigInteger bigEndy = BigInteger.valueOf(y + 4);
            BigInteger numIndexes = map.getIndexCount();
            BigInteger numIndexesMinus1 = numIndexes.subtract(BigInteger.ONE);
            numIndexesMinus1.max(BigInteger.ZERO);
            BigInteger start = this.getIndex(bigStarty, bigHeight, numIndexes, numIndexesMinus1);
            BigInteger end = this.getIndex(bigEndy, bigHeight, numIndexes, numIndexesMinus1);
            FieldSelection fs = new FieldSelection();
            fs.addRange(start, end.add(BigInteger.ONE));
            AddressSet set = map.getAddressSet(fs);
            if (set.isEmpty()) {
                return null;
            }
            Address addr = this.markers.findFirstAddressInCommon((AddressSetView)set);
            if (addr == null) {
                addr = set.getMinAddress();
            }
            if (this.listener != null) {
                loc = this.listener.getProgramLocation(new MarkerLocation(this, addr, x, y));
            }
            if (loc == null) {
                loc = new ProgramLocation(this.mgr.getProgram(), addr);
            }
        }
        return loc;
    }

    private BigInteger getIndex(BigInteger bigStarty, BigDecimal bigHeight, BigInteger numIndexes, BigInteger numIndexesMinus1) {
        BigDecimal total = new BigDecimal(bigStarty.multiply(numIndexes));
        BigDecimal div = total.divideToIntegralValue(bigHeight);
        BigInteger index = div.toBigInteger();
        index = index.min(numIndexesMinus1);
        return index;
    }

    private boolean overviewContains(int index) {
        for (int i = 0; i < 4; ++i) {
            if (!this.overview.contains(index - i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean state) {
        this.active = state;
        this.mgr.update();
    }

    @Override
    public AddressSet getAddressSet() {
        this.assertSwing();
        return this.markers.getCombinedAddressSet();
    }

    @Override
    public Address getMinAddress() {
        this.assertSwing();
        return this.markers.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        this.assertSwing();
        return this.markers.getMaxAddress();
    }

    @Override
    public boolean intersects(Address start, Address end) {
        this.assertSwing();
        return this.markers.intersects(start, end);
    }

    private void assertSwing() {
        SystemUtilities.assertThisIsTheSwingThread((String)"Calls to the MarkerSetImpl must be made on the Swing thread");
    }
}

