/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.compositeeditor.BitFieldEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeChangeListener;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeAlignmentHelper;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.ResourceManager;

public class BitFieldEditorDialog
extends DialogComponentProvider {
    private static final Icon ADD_ICON = ResourceManager.loadImage((String)"images/Plus.png");
    private static final Icon EDIT_ICON = ResourceManager.loadImage((String)"images/move.png");
    private static final Icon DELETE_ICON = ResourceManager.loadImage((String)"images/edit-delete.png");
    private DataTypeManagerService dtmService;
    private Composite composite;
    private CompositeChangeListener listener;
    private BitFieldEditorPanel bitFieldEditorPanel;

    BitFieldEditorDialog(Composite composite, DataTypeManagerService dtmService, int editOrdinal, CompositeChangeListener listener) {
        super("Edit " + BitFieldEditorDialog.getCompositeType(composite) + " Bitfield");
        this.composite = composite;
        this.listener = listener;
        this.dtmService = dtmService;
        this.addButtons();
        this.addWorkPanel(this.buildWorkPanel(editOrdinal));
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.addActions();
        this.setHelpLocation(new HelpLocation("DataTypeEditors", "Structure_Bitfield_Editor"));
    }

    private void addButtons() {
        this.addOKButton();
        this.addCancelButton();
        if (this.composite instanceof Structure) {
            this.addApplyButton();
            this.setApplyEnabled(false);
        }
    }

    private static DataTypeComponent getEditComponent(ActionContext context, boolean bitFieldOnly) {
        if (!(context instanceof BitFieldEditorPanel.BitFieldEditorContext)) {
            return null;
        }
        BitFieldEditorPanel.BitFieldEditorContext editorContext = (BitFieldEditorPanel.BitFieldEditorContext)context;
        DataTypeComponent dtc = editorContext.getSelectedComponent();
        if (dtc != null && (!bitFieldOnly || dtc.isBitFieldComponent())) {
            return dtc;
        }
        return null;
    }

    private void addActions() {
        this.addAction((DockingActionIf)new AddBitFieldAction());
        this.addAction((DockingActionIf)new EditBitFieldAction());
        this.addAction((DockingActionIf)new DeleteComponentAction());
    }

    protected void applyCallback() {
        if (this.bitFieldEditorPanel.isEditing() && this.bitFieldEditorPanel.apply(this.listener)) {
            this.setApplyEnabled(false);
        }
    }

    protected void okCallback() {
        if (!this.bitFieldEditorPanel.isEditing() || this.bitFieldEditorPanel.apply(this.listener)) {
            this.close();
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        ActionContext context = this.bitFieldEditorPanel.getActionContext(event);
        if (context != null) {
            return context;
        }
        return super.getActionContext(event);
    }

    protected void cancelCallback() {
        if (!this.bitFieldEditorPanel.endCurrentEdit()) {
            return;
        }
        super.cancelCallback();
    }

    private JComponent buildWorkPanel(int editOrdinal) {
        this.bitFieldEditorPanel = new BitFieldEditorPanel(this.composite, this.dtmService);
        if (editOrdinal < 0) {
            this.initAdd(-editOrdinal - 1);
        } else {
            this.initEdit(editOrdinal, false);
        }
        return this.bitFieldEditorPanel;
    }

    private static String getCompositeType(Composite composite) {
        if (composite.isInternallyAligned()) {
            throw new IllegalArgumentException("Aligned use not supported");
        }
        String alignmentMode = composite.isInternallyAligned() ? "Aligned" : "Unaligned";
        String type = composite instanceof Union ? "Union" : "Structure";
        return alignmentMode + " " + type;
    }

    private void initAdd(int ordinal) {
        DataType baseDataType = null;
        int offset = 0;
        if (ordinal < this.composite.getNumComponents()) {
            DataTypeComponent dtc = this.composite.getComponent(ordinal);
            offset = dtc.getOffset();
            if (dtc.isBitFieldComponent()) {
                baseDataType = ((BitFieldDataType)dtc.getDataType()).getBaseDataType();
            }
        } else if (!this.composite.isNotYetDefined()) {
            offset = this.composite.getLength();
        }
        this.bitFieldEditorPanel.initAdd(baseDataType, offset, 0, false);
        this.setApplyEnabled(true);
    }

    private void initEdit(int editOrdinal, boolean useExistingAllocationSize) throws ArrayIndexOutOfBoundsException {
        DataTypeComponent dtc = this.composite.getComponent(editOrdinal);
        if (!dtc.isBitFieldComponent()) {
            throw new IllegalArgumentException("editOrdinal does not correspond to bitfield");
        }
        this.bitFieldEditorPanel.initEdit(dtc, BitFieldEditorDialog.getPreferredAllocationOffset(dtc), useExistingAllocationSize);
        this.setApplyEnabled(true);
    }

    static int getPreferredAllocationOffset(DataTypeComponent bitfieldDtc) {
        Composite composite = (Composite)bitfieldDtc.getParent();
        if (composite instanceof Union) {
            return 0;
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)bitfieldDtc.getDataType();
        int offset = bitfieldDtc.getOffset();
        int baseTypeSize = bitfieldDt.getBaseTypeSize();
        if (bitfieldDtc.getLength() >= baseTypeSize) {
            return offset;
        }
        DataOrganization dataOrganization = composite.getDataOrganization();
        int alignment = CompositeAlignmentHelper.getPackedAlignment((DataOrganization)dataOrganization, (int)0, (DataType)bitfieldDt.getBaseDataType(), (int)bitfieldDt.getBaseTypeSize());
        int adjustedOffset = offset - offset % alignment;
        if (bitfieldDtc.getEndOffset() <= adjustedOffset + baseTypeSize - 1) {
            return adjustedOffset;
        }
        return offset;
    }

    private class DeleteComponentAction
    extends DockingAction {
        DeleteComponentAction() {
            super("Delete", "BitFieldEditorDialog");
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, DELETE_ICON));
        }

        public void actionPerformed(ActionContext context) {
            DataTypeComponent bitfieldDtc = BitFieldEditorDialog.getEditComponent(context, false);
            if (bitfieldDtc == null) {
                return;
            }
            int ordinal = bitfieldDtc.getOrdinal();
            BitFieldEditorDialog.this.composite.delete(ordinal);
            BitFieldEditorDialog.this.bitFieldEditorPanel.componentDeleted(ordinal);
            if (BitFieldEditorDialog.this.listener != null) {
                BitFieldEditorDialog.this.listener.componentChanged(ordinal);
            }
        }

        public boolean isEnabledForContext(ActionContext context) {
            return BitFieldEditorDialog.getEditComponent(context, false) != null;
        }
    }

    private class AddBitFieldAction
    extends DockingAction {
        AddBitFieldAction() {
            super("Add Bitfield", "BitFieldEditorDialog");
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, ADD_ICON));
            this.setHelpLocation(new HelpLocation("DataTypeEditors", "Structure_Editor_Add_Bitfield"));
        }

        public void actionPerformed(ActionContext context) {
            if (!BitFieldEditorDialog.this.bitFieldEditorPanel.endCurrentEdit()) {
                return;
            }
            BitFieldEditorPanel.BitFieldEditorContext editorContext = (BitFieldEditorPanel.BitFieldEditorContext)context;
            BitFieldEditorDialog.this.bitFieldEditorPanel.initAdd(null, editorContext.getAllocationOffset(), editorContext.getSelectedBitOffset(), true);
            BitFieldEditorDialog.this.setApplyEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return context instanceof BitFieldEditorPanel.BitFieldEditorContext && !BitFieldEditorDialog.this.bitFieldEditorPanel.isAdding();
        }
    }

    private class EditBitFieldAction
    extends DockingAction {
        EditBitFieldAction() {
            super("Edit Bitfield", "BitFieldEditorDialog");
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, EDIT_ICON));
            this.setHelpLocation(new HelpLocation("DataTypeEditors", "Structure_Editor_Edit_Bitfield"));
        }

        public void actionPerformed(ActionContext context) {
            DataTypeComponent bitfieldDtc = BitFieldEditorDialog.getEditComponent(context, true);
            if (bitfieldDtc == null || !BitFieldEditorDialog.this.bitFieldEditorPanel.endCurrentEdit()) {
                return;
            }
            BitFieldEditorDialog.this.initEdit(bitfieldDtc.getOrdinal(), true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return BitFieldEditorDialog.getEditComponent(context, true) != null;
        }
    }
}

