/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.context;

import docking.ComponentProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import java.awt.Component;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ProgramSymbolActionContext
extends ProgramActionContext {
    private final long[] symbolIDs;

    public ProgramSymbolActionContext(ComponentProvider provider, Program program, long[] symbolIDs, Component sourceComponent) {
        super(provider, program, sourceComponent);
        this.symbolIDs = symbolIDs;
    }

    public int getSymbolCount() {
        return this.symbolIDs != null ? this.symbolIDs.length : 0;
    }

    public Symbol getFirstSymbol() {
        if (this.symbolIDs == null || this.symbolIDs.length == 0) {
            return null;
        }
        return this.program.getSymbolTable().getSymbol(this.symbolIDs[0]);
    }

    public SymbolIterator getSymbols() {
        return new MySymbolIterator();
    }

    private class MySymbolIterator
    implements SymbolIterator {
        private int index = -1;
        private Symbol symbol = null;

        private MySymbolIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Symbol> iterator() {
            return this;
        }

        public boolean hasNext() {
            if (this.symbol != null) {
                return true;
            }
            if (ProgramSymbolActionContext.this.symbolIDs == null) {
                return false;
            }
            while (this.index < ProgramSymbolActionContext.this.symbolIDs.length - 1) {
                this.symbol = ProgramSymbolActionContext.this.program.getSymbolTable().getSymbol(ProgramSymbolActionContext.this.symbolIDs[++this.index]);
                if (this.symbol == null) continue;
                return true;
            }
            return false;
        }

        public Symbol next() {
            if (this.hasNext()) {
                Symbol s = this.symbol;
                this.symbol = null;
                return s;
            }
            throw new NoSuchElementException();
        }
    }
}

