/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class SetLabelNamespaceCmd
implements Command {
    private SymbolTable st;
    private Address addr;
    private String name;
    private Namespace oldNamespace;
    private Namespace newNamespace;
    private String errorMsg = "";

    public SetLabelNamespaceCmd(Address addr, String name, Namespace oldNamespace, Namespace newNamespace) {
        this.addr = addr;
        this.name = name;
        this.oldNamespace = oldNamespace;
        this.newNamespace = newNamespace;
    }

    public boolean applyTo(DomainObject obj) {
        this.st = ((Program)obj).getSymbolTable();
        Symbol s = this.st.getSymbol(this.name, this.addr, this.oldNamespace);
        if (s == null) {
            this.errorMsg = "No symbol named " + this.name + " found at address " + this.addr + " in namespace " + this.oldNamespace;
            return false;
        }
        try {
            s.setNamespace(this.newNamespace);
            return true;
        }
        catch (DuplicateNameException e) {
            this.errorMsg = "Symbol named " + this.name + " already exists in namespace " + this.newNamespace;
        }
        catch (InvalidInputException e) {
            this.errorMsg = e.getMessage();
        }
        catch (CircularDependencyException e) {
            this.errorMsg = e.getMessage();
        }
        return false;
    }

    public String getName() {
        return "Set Namespace";
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }
}

