/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompileResultsListener;
import ghidra.app.decompiler.component.DecompilerCallbackHandler;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.EmptyDecompileData;
import ghidra.app.plugin.core.decompile.DecompilerClipboardProvider;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import java.awt.BorderLayout;
import javax.swing.JPanel;

public class CDisplayPanel
extends JPanel
implements DecompilerCallbackHandler {
    private DecompilerController controller;
    private DecompileResultsListener listener;
    private ProgramLocationListener locationListener;

    public CDisplayPanel(DecompileResultsListener listener) {
        this(new DecompileOptions(), listener);
    }

    public CDisplayPanel(DecompileOptions decompileOptions, DecompileResultsListener listener) {
        super(new BorderLayout());
        this.listener = listener;
        this.controller = new ExtendedDecompilerController(this, decompileOptions, null);
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        this.add(decompilerPanel);
    }

    public void setProgramLocationListener(ProgramLocationListener locationListener) {
        this.locationListener = locationListener;
    }

    public DecompilerPanel getDecompilerPanel() {
        return this.controller.getDecompilerPanel();
    }

    public void showFunction(Program program, Address address) {
        this.controller.display(program, new ProgramLocation(program, address), new ViewerPosition(0, 0, 0));
    }

    public void showFunction(Function function) {
        if (function == null) {
            this.clearAndShowMessage("No Function");
            return;
        }
        if (function.isExternal()) {
            this.clearAndShowMessage("\"" + function.getName(true) + "\" is an external function.");
            return;
        }
        Program program = function.getProgram();
        Address entry = function.getEntryPoint();
        ProgramLocation location = new ProgramLocation(program, entry);
        this.controller.display(program, location, new ViewerPosition(0, 0, 0));
    }

    @Override
    public void contextChanged() {
    }

    @Override
    public void decompileDataChanged(DecompileData decompileData) {
    }

    @Override
    public void exportLocation() {
    }

    @Override
    public void annotationClicked(AnnotatedTextFieldElement annotation, boolean newWindow) {
    }

    @Override
    public void goToAddress(Address addr, boolean newWindow) {
    }

    @Override
    public void goToLabel(String labelName, boolean newWindow) {
    }

    @Override
    public void goToScalar(long value, boolean newWindow) {
    }

    @Override
    public void goToFunction(Function function, boolean newWindow) {
    }

    @Override
    public void locationChanged(ProgramLocation programLocation) {
        if (this.locationListener == null) {
            return;
        }
        this.locationListener.programLocationChanged(programLocation, null);
    }

    @Override
    public void selectionChanged(ProgramSelection programSelection) {
    }

    @Override
    public void setStatusMessage(String message) {
    }

    public void clearAndShowMessage(String message) {
        this.controller.setDecompileData(new EmptyDecompileData(message));
        this.paintImmediately(this.getBounds());
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        this.controller.setMouseNavigationEnabled(enabled);
    }

    public void dispose() {
        this.controller.dispose();
    }

    class ExtendedDecompilerController
    extends DecompilerController {
        public ExtendedDecompilerController(DecompilerCallbackHandler handler, DecompileOptions options, DecompilerClipboardProvider clipboard) {
            super(handler, options, clipboard);
        }

        @Override
        public void setDecompileData(DecompileData decompileData) {
            super.setDecompileData(decompileData);
            if (CDisplayPanel.this.listener != null) {
                CDisplayPanel.this.listener.setDecompileData(decompileData);
            }
        }

        @Override
        public void dispose() {
            CDisplayPanel.this.listener = null;
            super.dispose();
        }
    }
}

