/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.DecompileCallback;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompilerDisposer;
import ghidra.app.decompiler.LimitedByteBuffer;
import ghidra.program.model.lang.PackedBytes;
import ghidra.util.Msg;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecompileProcess {
    private static final byte[] command_start = new byte[]{0, 0, 1, 2};
    private static final byte[] command_end = new byte[]{0, 0, 1, 3};
    private static final byte[] query_response_start = new byte[]{0, 0, 1, 8};
    private static final byte[] query_response_end = new byte[]{0, 0, 1, 9};
    private static final byte[] string_start = new byte[]{0, 0, 1, 14};
    private static final byte[] string_end = new byte[]{0, 0, 1, 15};
    private static final byte[] exception_start = new byte[]{0, 0, 1, 10};
    private static final byte[] exception_end = new byte[]{0, 0, 1, 11};
    private static final byte[] byte_start = new byte[]{0, 0, 1, 12};
    private static final byte[] byte_end = new byte[]{0, 0, 1, 13};
    private Runtime runtime = Runtime.getRuntime();
    private String[] exepath;
    private Runnable timeoutRunnable;
    private volatile Process nativeProcess;
    private volatile InputStream nativeIn;
    private volatile OutputStream nativeOut;
    private volatile boolean statusGood;
    private int archId = -1;
    private DecompileCallback callback;
    private int maxResultSizeMBYtes = 50;
    private boolean showNamespace;
    private volatile DisposeState disposestate = DisposeState.NOT_DISPOSED;

    public DecompileProcess(String path) {
        this.exepath = new String[]{path};
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                DecompileProcess.this.dispose();
                DecompileProcess.this.disposestate = DisposeState.DISPOSED_ON_TIMEOUT;
            }
        };
    }

    public void dispose() {
        if (this.disposestate != DisposeState.NOT_DISPOSED) {
            return;
        }
        this.disposestate = DisposeState.DISPOSED_ON_CANCEL;
        this.statusGood = false;
        DecompilerDisposer.dispose(this.nativeProcess, this.nativeOut, this.nativeIn);
    }

    public DisposeState getDisposeState() {
        return this.disposestate;
    }

    private void setup() throws IOException {
        if (this.disposestate != DisposeState.NOT_DISPOSED) {
            throw new IOException("Decompiler has been disposed");
        }
        if (this.nativeProcess != null) {
            this.nativeProcess.destroy();
            this.nativeProcess = null;
        }
        if (this.exepath == null) {
            throw new IOException("Could not find decompiler executable");
        }
        try {
            this.nativeProcess = this.runtime.exec(this.exepath);
            this.nativeIn = this.nativeProcess.getInputStream();
            this.nativeOut = this.nativeProcess.getOutputStream();
            this.statusGood = true;
        }
        catch (IOException e) {
            this.disposestate = DisposeState.DISPOSED_ON_STARTUP_FAILURE;
            this.statusGood = false;
            Msg.showError((Object)this, null, (String)"Problem launching decompiler", (Object)"Please report this stack trace to the Ghidra Team", (Throwable)e);
            throw e;
        }
    }

    private int readToBurst() throws IOException {
        if (this.nativeIn == null) {
            throw new IOException("Decompiler disposed!");
        }
        while (true) {
            int cur;
            if ((cur = this.nativeIn.read()) > 0) {
                continue;
            }
            if (cur == -1) break;
            while ((cur = this.nativeIn.read()) == 0) {
            }
            if (cur == 1) {
                cur = this.nativeIn.read();
                if (cur == -1) break;
                return cur;
            }
            if (cur == -1) break;
        }
        throw new IOException("Decompiler process died");
    }

    private void readToResponse() throws IOException, DecompileException {
        int type;
        this.nativeOut.flush();
        while (((type = this.readToBurst()) & 1) == 1) {
        }
        if (type == 10) {
            this.generateException();
        }
        if (type == 6) {
            return;
        }
        throw new IOException("Ghidra/decompiler alignment error");
    }

    private int readToBuffer(LimitedByteBuffer buf) throws IOException {
        int cur;
        do {
            cur = this.nativeIn.read();
            while (cur > 0) {
                buf.append((byte)cur);
                cur = this.nativeIn.read();
            }
            if (cur == -1) break;
            while ((cur = this.nativeIn.read()) == 0) {
            }
            if (cur != 1 || (cur = this.nativeIn.read()) <= 0) continue;
            return cur;
        } while (cur != -1);
        throw new IOException("Decompiler process died");
    }

    private String readQueryString() throws IOException {
        int type = this.readToBurst();
        if (type != 14) {
            throw new IOException("GHIDRA/decompiler alignment error");
        }
        LimitedByteBuffer buf = new LimitedByteBuffer(16, 65536);
        type = this.readToBuffer(buf);
        if (type != 15) {
            throw new IOException("GHIDRA/decompiler alignment error");
        }
        return buf.toString();
    }

    private void writeString(String msg) throws IOException {
        this.write(string_start);
        this.write(msg.getBytes());
        this.write(string_end);
    }

    private void writeBytes(PackedBytes out) throws IOException {
        this.write(string_start);
        int sz = out.size();
        int sz1 = (sz & 0x3F) + 32;
        int sz2 = ((sz >>>= 6) & 0x3F) + 32;
        int sz3 = ((sz >>>= 6) & 0x3F) + 32;
        int sz4 = ((sz >>>= 6) & 0x3F) + 32;
        this.write(sz1);
        this.write(sz2);
        this.write(sz3);
        this.write(sz4);
        if (this.nativeOut != null) {
            out.writeTo(this.nativeOut);
        }
        this.write(string_end);
    }

    private void generateException() throws IOException, DecompileException {
        String type = this.readQueryString();
        String message = this.readQueryString();
        this.readToBurst();
        if (type.equals("alignment")) {
            throw new IOException("Alignment error: " + message);
        }
        throw new DecompileException(type, message);
    }

    /*
     * Unable to fully structure code
     */
    private LimitedByteBuffer readResponse() throws IOException, DecompileException {
        this.readToResponse();
        type = this.readToBurst();
        retbuf = null;
        buf = null;
        while (type != 7) {
            switch (type) {
                case 4: {
                    name = this.readQueryString();
                    try {
                        if (name.length() < 4) {
                            throw new Exception("Bad decompiler query: " + name);
                        }
                        switch (name.charAt(3)) {
                            case 'B': {
                                this.getBytes();
                                break;
                            }
                            case 'C': {
                                if (name.equals("getComments")) {
                                    this.getComments();
                                    break;
                                }
                                if (name.equals("getCallFixup")) {
                                    this.getPcodeInject(1);
                                    break;
                                }
                                if (name.equals("getCallotherFixup")) {
                                    this.getPcodeInject(2);
                                    break;
                                }
                                if (name.equals("getCallMech")) {
                                    this.getPcodeInject(3);
                                    break;
                                }
                                this.getCPoolRef();
                                break;
                            }
                            case 'E': {
                                this.getExternalRefXML();
                                break;
                            }
                            case 'M': {
                                this.getMappedSymbolsXML();
                                break;
                            }
                            case 'P': {
                                this.getPcodePacked();
                                break;
                            }
                            case 'R': {
                                if (name.equals("getRegister")) {
                                    this.getRegister();
                                    break;
                                }
                                this.getRegisterName();
                                break;
                            }
                            case 'S': {
                                this.getSymbol();
                                break;
                            }
                            case 'T': {
                                if (name.equals("getType")) {
                                    this.getType();
                                    break;
                                }
                                this.getTrackedRegisters();
                                break;
                            }
                            case 'U': {
                                this.getUserOpName();
                                break;
                            }
                            case 'X': {
                                this.getPcodeInject(4);
                                break;
                            }
                            default: {
                                throw new Exception("Unsupported decompiler query '" + name + "'");
                            }
                        }
                    }
                    catch (Exception e) {
                        this.write(DecompileProcess.exception_start);
                        extype = e.getClass().getName();
                        msg = e.getMessage();
                        if (msg == null) {
                            msg = "";
                        }
                        this.writeString(extype);
                        this.writeString(msg);
                        this.write(DecompileProcess.exception_end);
                        if (this.disposestate != DisposeState.NOT_DISPOSED) ** GOTO lbl75
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    }
lbl75:
                    // 3 sources

                    this.nativeOut.flush();
                    this.readToBurst();
                    break;
                }
                case 6: {
                    throw new IOException("GHIDRA/decompiler out of alignment");
                }
                case 10: {
                    this.generateException();
                    break;
                }
                case 14: {
                    if (buf != null) {
                        throw new IOException("Nested decompiler output");
                    }
                    buf = new LimitedByteBuffer(1024, this.maxResultSizeMBYtes << 20);
                    break;
                }
                case 15: {
                    if (buf == null) {
                        throw new IOException("Mismatched string header");
                    }
                    retbuf = buf;
                    buf = null;
                    break;
                }
                case 16: {
                    buf = new LimitedByteBuffer(64, 0x100000);
                    break;
                }
                case 17: {
                    if (buf == null) {
                        throw new IOException("Mismatched message header");
                    }
                    this.callback.setNativeMessage(buf.toString());
                    buf = null;
                    break;
                }
                default: {
                    throw new IOException("GHIDRA/decompiler alignment error");
                }
            }
            if (buf == null) {
                type = this.readToBurst();
                continue;
            }
            type = this.readToBuffer(buf);
        }
        return retbuf;
    }

    public synchronized void registerProgram(DecompileCallback cback, String pspecxml, String cspecxml, String tspecxml, String coretypesxml) throws IOException, DecompileException {
        this.callback = cback;
        this.callback.setShowNamespace(this.showNamespace);
        this.setup();
        String restring = null;
        try {
            this.write(command_start);
            this.writeString("registerProgram");
            this.writeString(pspecxml);
            this.writeString(cspecxml);
            this.writeString(tspecxml);
            this.writeString(coretypesxml);
            this.write(command_end);
            restring = this.readResponse().toString();
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
        this.archId = Integer.parseInt(restring);
    }

    public synchronized int deregisterProgram() throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException("deregisterProgram called on bad process");
        }
        this.statusGood = false;
        String restring = null;
        this.write(command_start);
        this.writeString("deregisterProgram");
        this.writeString(Integer.toString(this.archId));
        this.write(command_end);
        restring = this.readResponse().toString();
        this.callback = null;
        int res = Integer.parseInt(restring);
        return res;
    }

    public synchronized LimitedByteBuffer sendCommand(String command) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        LimitedByteBuffer resbuf = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.write(command_end);
            resbuf = this.readResponse();
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
        return resbuf;
    }

    public synchronized boolean isReady() {
        return this.statusGood;
    }

    public synchronized LimitedByteBuffer sendCommand1ParamTimeout(String command, String param, int timeoutSecs) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        LimitedByteBuffer resbuf = null;
        GTimerMonitor timerMonitor = GTimer.scheduleRunnable((long)(timeoutSecs * 1000), (Runnable)this.timeoutRunnable);
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(param);
            this.write(command_end);
            resbuf = this.readResponse();
        }
        catch (IOException e) {
            this.statusGood = false;
            if (timerMonitor.didRun()) {
                throw new DecompileException("process", "timeout");
            }
            throw e;
        }
        finally {
            timerMonitor.cancel();
        }
        return resbuf;
    }

    public synchronized LimitedByteBuffer sendCommand2Params(String command, String param1, String param2) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        LimitedByteBuffer resbuf = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(param1);
            this.writeString(param2);
            this.write(command_end);
            resbuf = this.readResponse();
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
        return resbuf;
    }

    public void setMaxResultSize(int maxResultSizeMBytes) {
        this.maxResultSizeMBYtes = maxResultSizeMBytes;
    }

    public void setShowNamespace(boolean showNamespace) {
        this.showNamespace = showNamespace;
        this.callback.setShowNamespace(showNamespace);
    }

    public synchronized LimitedByteBuffer sendCommand1Param(String command, String param1) throws IOException, DecompileException {
        if (!this.statusGood) {
            throw new IOException(command + " called on bad process");
        }
        LimitedByteBuffer resbuf = null;
        try {
            this.write(command_start);
            this.writeString(command);
            this.writeString(Integer.toString(this.archId));
            this.writeString(param1);
            this.write(command_end);
            resbuf = this.readResponse();
        }
        catch (IOException e) {
            this.statusGood = false;
            throw e;
        }
        return resbuf;
    }

    private void getRegister() throws IOException {
        String name = this.readQueryString();
        String res = this.callback.getRegister(name);
        this.write(query_response_start);
        if (res != null && res.length() != 0) {
            this.writeString(res);
        }
        this.write(query_response_end);
    }

    private void getRegisterName() throws IOException {
        String addr = this.readQueryString();
        String res = this.callback.getRegisterName(addr);
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getTrackedRegisters() throws IOException {
        String addr = this.readQueryString();
        String res = this.callback.getTrackedRegisters(addr);
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getUserOpName() throws IOException {
        String indexStr = this.readQueryString();
        String res = this.callback.getUserOpName(indexStr);
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getPcodePacked() throws IOException {
        String addr = this.readQueryString();
        PackedBytes out = this.callback.getPcodePacked(addr);
        this.write(query_response_start);
        if (out != null && out.size() != 0) {
            this.writeBytes(out);
        }
        this.write(query_response_end);
    }

    private void getPcodeInject(int type) throws IOException {
        String name = this.readQueryString();
        String context = this.readQueryString();
        String res = this.callback.getPcodeInject(name, context, type);
        this.write(query_response_start);
        if (res != null && res.length() != 0) {
            this.writeString(res);
        }
        this.write(query_response_end);
    }

    private void getCPoolRef() throws IOException {
        String liststring = this.readQueryString();
        String[] split = liststring.split(",");
        long[] refs = new long[split.length];
        for (int i = 0; i < split.length; ++i) {
            refs[i] = Long.parseUnsignedLong(split[i], 16);
        }
        String res = this.callback.getCPoolRef(refs);
        this.write(query_response_start);
        if (res != null && res.length() != 0) {
            this.writeString(res);
        }
        this.write(query_response_end);
    }

    private void getMappedSymbolsXML() throws IOException {
        String addr = this.readQueryString();
        String res = this.callback.getMappedSymbolsXML(addr);
        this.write(query_response_start);
        if (res != null && res.length() != 0) {
            this.writeString(res);
        }
        this.write(query_response_end);
    }

    private void getExternalRefXML() throws IOException {
        String refaddr = this.readQueryString();
        String res = this.callback.getExternalRefXML(refaddr);
        this.write(query_response_start);
        if (res != null && res.length() != 0) {
            this.writeString(res);
        }
        this.write(query_response_end);
    }

    private void getSymbol() throws IOException {
        String addr = this.readQueryString();
        String res = this.callback.getSymbol(addr);
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getComments() throws IOException {
        String flags;
        String addr = this.readQueryString();
        String res = this.callback.getComments(addr, flags = this.readQueryString());
        if (res == null) {
            res = "";
        }
        this.write(query_response_start);
        this.writeString(res);
        this.write(query_response_end);
    }

    private void getType() throws IOException {
        String name = this.readQueryString();
        String id = this.readQueryString();
        String res = this.callback.getType(name, id);
        this.write(query_response_start);
        if (res != null && res.length() != 0) {
            this.writeString(res);
        }
        this.write(query_response_end);
    }

    private void getBytes() throws IOException {
        String size = this.readQueryString();
        byte[] res = this.callback.getBytes(size);
        this.write(query_response_start);
        if (res != null && res.length > 0) {
            this.write(byte_start);
            byte[] dblres = new byte[res.length * 2];
            for (int i = 0; i < res.length; ++i) {
                dblres[i * 2] = (byte)((res[i] >> 4 & 0xF) + 65);
                dblres[i * 2 + 1] = (byte)((res[i] & 0xF) + 65);
            }
            this.write(dblres);
            this.write(byte_end);
        }
        this.write(query_response_end);
    }

    private void write(byte[] bytes) throws IOException {
        if (this.nativeOut == null) {
            return;
        }
        this.nativeOut.write(bytes);
    }

    private void write(int i) throws IOException {
        if (this.nativeOut == null) {
            return;
        }
        this.nativeOut.write(i);
    }

    public static enum DisposeState {
        NOT_DISPOSED,
        DISPOSED_ON_TIMEOUT,
        DISPOSED_ON_CANCEL,
        DISPOSED_ON_STARTUP_FAILURE;

    }
}

