/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.AbstractMagePanelManager;
import docking.wizard.MagePanel;
import docking.wizard.WizardState;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.AddToSessionTask;
import ghidra.feature.vt.gui.wizard.AddressSetOptionsPanel;
import ghidra.feature.vt.gui.wizard.CorrelatorPanel;
import ghidra.feature.vt.gui.wizard.LimitAddressSetsPanel;
import ghidra.feature.vt.gui.wizard.OptionsPanel;
import ghidra.feature.vt.gui.wizard.SummaryPanel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.program.model.listing.Program;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;

public class VTAddToSessionWizardManager
extends AbstractMagePanelManager<VTWizardStateKey> {
    private final VTController controller;

    public VTAddToSessionWizardManager(VTController controller) {
        super(new WizardState());
        this.controller = controller;
        Program sourceProgram = controller.getSourceProgram();
        Program destinationProgram = controller.getDestinationProgram();
        VTSession session = controller.getSession();
        WizardState state = this.getState();
        state.put((Object)VTWizardStateKey.SOURCE_PROGRAM, (Object)sourceProgram);
        state.put((Object)VTWizardStateKey.DESTINATION_PROGRAM, (Object)destinationProgram);
        state.put((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE, (Object)sourceProgram.getDomainFile());
        state.put((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE, (Object)destinationProgram.getDomainFile());
        state.put((Object)VTWizardStateKey.EXISTING_SESSION, (Object)session);
        state.put((Object)VTWizardStateKey.SESSION_NAME, (Object)session.getName());
        state.put((Object)VTWizardStateKey.WIZARD_OP_DESCRIPTION, (Object)"Add to Version Tracking Session");
        state.put((Object)VTWizardStateKey.SOURCE_SELECTION, (Object)controller.getSelectionInSourceTool());
        state.put((Object)VTWizardStateKey.DESTINATION_SELECTION, (Object)controller.getSelectionInDestinationTool());
    }

    protected ArrayList<MagePanel<VTWizardStateKey>> createPanels() {
        ArrayList<MagePanel<VTWizardStateKey>> panels = new ArrayList<MagePanel<VTWizardStateKey>>();
        panels.add((MagePanel<VTWizardStateKey>)new CorrelatorPanel(this.controller.getSession()));
        panels.add((MagePanel<VTWizardStateKey>)new OptionsPanel());
        panels.add((MagePanel<VTWizardStateKey>)new AddressSetOptionsPanel());
        panels.add((MagePanel<VTWizardStateKey>)new LimitAddressSetsPanel(this.controller.getTool()));
        panels.add((MagePanel<VTWizardStateKey>)new SummaryPanel());
        return panels;
    }

    protected void doFinish() {
        try {
            AddToSessionTask task = new AddToSessionTask(this.controller, (WizardState<VTWizardStateKey>)this.getState());
            new TaskLauncher((Task)task, (Component)this.getWizardManager().getComponent());
        }
        finally {
            this.getWizardManager().completed(true);
        }
    }
}

