/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.test.TestThread;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import utilities.util.reflection.ReflectionUtilities;

public class TestReportingException
extends RuntimeException {
    private static final String[] GENERAL_USELESS_STACK_ELEMET_PATTERNS = new String[]{"java.awt.WaitDispatchSupport"};
    private static final String[] SWING_STACK_ELEMENT_PATTERNS = (String[])ArrayUtils.addAll((Object[])GENERAL_USELESS_STACK_ELEMET_PATTERNS, (Object[])new String[]{"java.awt.Event", "java.security", "java.awt.event"});
    private String userMessage;
    private String threadName;
    private Throwable t;
    private StackTraceElement[] testThreadTrace;

    public static TestReportingException fromSwingThread(String message, Throwable t) {
        StackTraceElement[] testThreadTrace = null;
        if (TestThread.isTestThread()) {
            Throwable testThrowable = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{TestReportingException.class});
            testThreadTrace = testThrowable.getStackTrace();
            testThreadTrace = TestThread.filterTrace(testThreadTrace);
            StackTraceElement[] awtThreadTrace = t.getStackTrace();
            awtThreadTrace = TestThread.filterTrace(awtThreadTrace);
            t.setStackTrace(awtThreadTrace);
        }
        TestReportingException e = new TestReportingException("AWT-EventQueue-0", t, testThreadTrace);
        e.userMessage = message;
        return e;
    }

    TestReportingException(String threadName, Throwable t) {
        this(threadName, t, null);
    }

    TestReportingException(String threadName, Throwable t, StackTraceElement[] testThreadTrace) {
        this.t = Objects.requireNonNull(t);
        this.threadName = Objects.requireNonNull(threadName);
        this.testThreadTrace = testThreadTrace;
    }

    public static String getSwingThreadTraceString(Throwable throwable) {
        StackTraceElement[] trace = throwable.getStackTrace();
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace((StackTraceElement[])trace, (String[])SWING_STACK_ELEMENT_PATTERNS);
        String className = throwable.getClass().getSimpleName();
        Object message = throwable.getMessage();
        message = message != null ? className + ": " + (String)message : className;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.append((CharSequence)message);
        writer.append('\n');
        TestReportingException.printTrace(filtered, writer);
        return stringWriter.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        String trace = this.buildStackTraceString();
        s.println(trace);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        String trace = this.buildStackTraceString();
        s.println(trace);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] trace = this.t.getStackTrace();
        return this.filterTrace(trace);
    }

    @Override
    public String getMessage() {
        return "(See log for more stack trace info)\n\n" + this.generateMessge();
    }

    private String buildStackTraceString() {
        String m = this.generateMessge();
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.append(m);
        writer.append('\n');
        StackTraceElement[] trace = this.t.getStackTrace();
        trace = this.filterTrace(trace);
        TestReportingException.printTrace(trace, writer);
        this.addAllCauseExceptions(writer);
        if (this.testThreadTrace != null) {
            writer.append("\nTest thread stack at that time:\n");
            TestReportingException.printTrace(this.testThreadTrace, writer);
        }
        String output = stringWriter.toString();
        return output;
    }

    private void addAllCauseExceptions(PrintWriter writer) {
        this.addCauseException(this.t, writer);
    }

    private void addCauseException(Throwable currentThrowable, PrintWriter writer) {
        Throwable theCause = currentThrowable.getCause();
        if (theCause == null) {
            return;
        }
        String defaultMessage = theCause.getClass().getSimpleName();
        String message = theCause.getMessage();
        message = message == null ? defaultMessage : message;
        writer.append("\nCaused By:\n");
        writer.append('\t').append(message).append('\n');
        StackTraceElement[] causeByTrace = theCause.getStackTrace();
        causeByTrace = this.filterTrace(causeByTrace);
        TestReportingException.printTrace(causeByTrace, writer);
        this.addCauseException(theCause, writer);
    }

    private String generateMessge() {
        String message = this.t.getMessage();
        message = message != null ? message : "";
        String messageWithName = this.t.getClass().getSimpleName() + ": " + message + " (thread '" + this.threadName + "')";
        if (this.userMessage != null) {
            messageWithName = this.userMessage + "\n\n" + messageWithName;
        }
        return messageWithName;
    }

    private StackTraceElement[] filterTrace(StackTraceElement[] trace) {
        if (this.threadName.contains("AWT-EventQueue")) {
            StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace((StackTraceElement[])trace, (String[])SWING_STACK_ELEMENT_PATTERNS);
            return filtered;
        }
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace((StackTraceElement[])trace, (String[])GENERAL_USELESS_STACK_ELEMET_PATTERNS);
        return filtered;
    }

    private static void printTrace(StackTraceElement[] trace, PrintWriter writer) {
        for (StackTraceElement element : trace) {
            writer.append("\tat ").append(element.toString()).append('\n');
        }
    }
}

