/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;

public class SetIterator<T>
implements IteratorSTL<T> {
    protected RedBlackTree<T, T> tree;
    protected RedBlackNode<T, T> node;
    public boolean erased = false;

    SetIterator(RedBlackTree<T, T> tree, RedBlackNode<T, T> node) {
        this.tree = tree;
        this.node = node;
    }

    SetIterator(RedBlackTree<T, T> tree, RedBlackNode<T, T> node, boolean erased) {
        this.tree = tree;
        this.node = node;
        this.erased = erased;
    }

    @Override
    public void assign(IteratorSTL<T> otherIterator) {
        SetIterator other = (SetIterator)otherIterator;
        this.tree = other.tree;
        this.node = other.node;
        this.erased = other.erased;
    }

    @Override
    public IteratorSTL<T> copy() {
        return new SetIterator<T>(this.tree, this.node, this.erased);
    }

    @Override
    public IteratorSTL<T> decrement() {
        if (this.node == null && this.tree.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node == null ? this.tree.getLast() : this.node.getPredecessor();
        this.erased = false;
        return this;
    }

    @Override
    public T get() {
        if (this.erased) {
            throw new IndexOutOfBoundsException("element erased");
        }
        if (this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.node.getKey();
    }

    @Override
    public IteratorSTL<T> increment() {
        if (!this.erased && this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.erased) {
            this.node = this.node.getSuccessor();
        }
        this.erased = false;
        return this;
    }

    @Override
    public void insert(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBegin() {
        if (this.erased) {
            throw new RuntimeException("Iterater in invalid state");
        }
        return this.node == this.tree.getFirst();
    }

    @Override
    public boolean isEnd() {
        if (this.erased) {
            throw new RuntimeException("Iterater in invalid state");
        }
        return this.node == null;
    }

    @Override
    public void set(T value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SetIterator other = (SetIterator)obj;
        return this.tree == other.tree && this.node == other.node && this.erased == other.erased;
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    @Override
    public IteratorSTL<T> decrement(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IteratorSTL<T> increment(int n) {
        throw new UnsupportedOperationException();
    }
}

