/*
 * Decompiled with CFR 0.152.
 */
package generic.io;

import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class JarWriter {
    protected JarOutputStream jarOut;
    private String[] excludedExtensions;

    public JarWriter(JarOutputStream jarOut) {
        this(jarOut, new String[0]);
    }

    public JarWriter(JarOutputStream jarOut, String[] excludedExtensions) {
        this.jarOut = jarOut;
        this.excludedExtensions = excludedExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outputFile(File baseFile, String jarPath, TaskMonitor monitor) {
        if (baseFile.isDirectory()) {
            return false;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(baseFile);
        }
        catch (FileNotFoundException fnfe) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + fnfe.getMessage()), (Throwable)fnfe);
            return false;
        }
        try {
            boolean bl = this.outputEntry(jarPath + baseFile.getName(), baseFile.lastModified(), in, monitor);
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean outputEntry(String path, long time, InputStream in, TaskMonitor monitor) {
        byte[] bytes = new byte[4096];
        int numRead = 0;
        ZipEntry entry = new ZipEntry(path);
        entry.setTime(time);
        try {
            monitor.setMessage("Writing " + path);
            this.jarOut.putNextEntry(entry);
            try {
                while ((numRead = in.read(bytes)) != -1) {
                    if (monitor.isCancelled()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.jarOut.write(bytes, 0, numRead);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException ioe) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
                return false;
            }
            finally {
                this.jarOut.closeEntry();
            }
        }
        catch (IOException ioe) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
        }
        return false;
    }

    public boolean outputRecursively(File baseFile, String jarPath, TaskMonitor monitor) {
        boolean succeeded = true;
        File[] subFiles = new File[]{};
        if (baseFile.isDirectory()) {
            subFiles = baseFile.listFiles();
            for (int i = 0; i < subFiles.length && !monitor.isCancelled(); ++i) {
                String newPath = jarPath + baseFile.getName() + File.separator;
                succeeded = this.outputRecursively(subFiles[i], newPath, monitor) && succeeded;
            }
        } else {
            String name = baseFile.getName();
            for (int i = 0; i < this.excludedExtensions.length; ++i) {
                if (!name.endsWith(this.excludedExtensions[i])) continue;
                return true;
            }
            succeeded = this.outputFile(baseFile, jarPath, monitor);
        }
        return succeeded;
    }

    public JarOutputStream getJarOutputStream() {
        return this.jarOut;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java JarWriter [sourceDir] [outputFilename]");
            System.exit(0);
        }
        try {
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(args[1]));
            JarWriter writer = new JarWriter(jarOut);
            writer.outputRecursively(new File(args[0]), "", TaskMonitorAdapter.DUMMY_MONITOR);
            jarOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

