/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.layers;

import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.configuration.ProvisionedConfigurationCompleter;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.config.ConfigId;

abstract class AbstractLayersCommand
extends AbstractStateCommand {
    @Argument(required=true, description="Configuration full name (<model>/<name>)", completer=ProvisionedConfigurationCompleter.class)
    private String configuration;

    AbstractLayersCommand() {
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }

    ConfigId getConfig() {
        if (this.configuration == null || this.configuration.isEmpty()) {
            return null;
        }
        int sep = this.configuration.indexOf("/");
        if (sep == -1 || sep == this.configuration.length() - 1) {
            return null;
        }
        return new ConfigId(this.configuration.substring(0, sep), this.configuration.substring(sep + 1));
    }

    protected ConfigInfo getConfiguration(State state) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        String path = "/configs/final/" + this.configuration + '/';
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(state.getContainer(), false);
        PathParser.parse(path, consumer);
        ConfigInfo ci = consumer.getConfig();
        if (ci == null) {
            throw new ProvisioningException("Not a valid config " + this.configuration);
        }
        return ci;
    }
}

